/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdTermState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IntBlockPool;
import org.apache.lucene.util.RecyclingByteBlockAllocator;
import org.apache.lucene.util.RecyclingIntBlockAllocator;

public class MemoryIndex {
    private static final boolean DEBUG = false;
    private final SortedMap<String, Info> fields = new TreeMap<String, Info>();
    private final boolean storeOffsets;
    private final boolean storePayloads;
    private final ByteBlockPool byteBlockPool;
    private final IntBlockPool intBlockPool;
    private final IntBlockPool.SliceWriter postingsWriter;
    private final BytesRefArray payloadsBytesRefs;
    private Counter bytesUsed;
    private boolean frozen = false;
    private Similarity normSimilarity = IndexSearcher.getDefaultSimilarity();

    public MemoryIndex() {
        this(false);
    }

    public MemoryIndex(boolean storeOffsets) {
        this(storeOffsets, false);
    }

    public MemoryIndex(boolean storeOffsets, boolean storePayloads) {
        this(storeOffsets, storePayloads, 0L);
    }

    MemoryIndex(boolean storeOffsets, boolean storePayloads, long maxReusedBytes) {
        this.storeOffsets = storeOffsets;
        this.storePayloads = storePayloads;
        this.bytesUsed = Counter.newCounter();
        int maxBufferedByteBlocks = (int)(maxReusedBytes / 2L / 32768L);
        int maxBufferedIntBlocks = (int)((maxReusedBytes - (long)(maxBufferedByteBlocks * 32768)) / 32768L);
        assert ((long)(maxBufferedByteBlocks * 32768 + maxBufferedIntBlocks * 8192 * 4) <= maxReusedBytes);
        this.byteBlockPool = new ByteBlockPool((ByteBlockPool.Allocator)new RecyclingByteBlockAllocator(32768, maxBufferedByteBlocks, this.bytesUsed));
        this.intBlockPool = new IntBlockPool((IntBlockPool.Allocator)new RecyclingIntBlockAllocator(8192, maxBufferedIntBlocks, this.bytesUsed));
        this.postingsWriter = new IntBlockPool.SliceWriter(this.intBlockPool);
        this.payloadsBytesRefs = storePayloads ? new BytesRefArray(this.bytesUsed) : null;
    }

    public void addField(String fieldName, String text, Analyzer analyzer) {
        TokenStream stream;
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (analyzer == null) {
            throw new IllegalArgumentException("analyzer must not be null");
        }
        try {
            stream = analyzer.tokenStream(fieldName, text);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.addField(fieldName, stream, 1.0f, analyzer.getPositionIncrementGap(fieldName), analyzer.getOffsetGap(fieldName));
    }

    public <T> TokenStream keywordTokenStream(final Collection<T> keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null");
        }
        return new TokenStream(){
            private Iterator<T> iter;
            private int start;
            private final CharTermAttribute termAtt;
            private final OffsetAttribute offsetAtt;
            {
                this.iter = keywords.iterator();
                this.start = 0;
                this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
            }

            public boolean incrementToken() {
                if (!this.iter.hasNext()) {
                    return false;
                }
                Object obj = this.iter.next();
                if (obj == null) {
                    throw new IllegalArgumentException("keyword must not be null");
                }
                String term = obj.toString();
                this.clearAttributes();
                this.termAtt.setEmpty().append(term);
                this.offsetAtt.setOffset(this.start, this.start + this.termAtt.length());
                this.start += term.length() + 1;
                return true;
            }
        };
    }

    public void addField(String fieldName, TokenStream stream) {
        this.addField(fieldName, stream, 1.0f);
    }

    public void addField(String fieldName, TokenStream stream, float boost) {
        this.addField(fieldName, stream, boost, 0);
    }

    public void addField(String fieldName, TokenStream stream, float boost, int positionIncrementGap) {
        this.addField(fieldName, stream, boost, positionIncrementGap, 1);
    }

    public void addField(String fieldName, TokenStream tokenStream, float boost, int positionIncrementGap, int offsetGap) {
        try (TokenStream stream = tokenStream;){
            SliceByteStartArray sliceArray;
            BytesRefHash terms;
            FieldInfo fieldInfo;
            if (this.frozen) {
                throw new IllegalArgumentException("Cannot call addField() when MemoryIndex is frozen");
            }
            if (fieldName == null) {
                throw new IllegalArgumentException("fieldName must not be null");
            }
            if (stream == null) {
                throw new IllegalArgumentException("token stream must not be null");
            }
            if (boost <= 0.0f) {
                throw new IllegalArgumentException("boost factor must be greater than 0.0");
            }
            int numTokens = 0;
            int numOverlapTokens = 0;
            int pos = -1;
            long sumTotalTermFreq = 0L;
            int offset = 0;
            Info info = (Info)this.fields.get(fieldName);
            if (info != null) {
                fieldInfo = info.fieldInfo;
                numTokens = info.numTokens;
                numOverlapTokens = info.numOverlapTokens;
                pos = info.lastPosition + positionIncrementGap;
                offset = info.lastOffset + offsetGap;
                terms = info.terms;
                boost *= info.boost;
                sliceArray = info.sliceArray;
                sumTotalTermFreq = info.sumTotalTermFreq;
            } else {
                fieldInfo = new FieldInfo(fieldName, this.fields.size(), true, false, this.storePayloads, this.storeOffsets ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS, DocValuesType.NONE, -1L, Collections.emptyMap());
                sliceArray = new SliceByteStartArray(16);
                terms = new BytesRefHash(this.byteBlockPool, 16, (BytesRefHash.BytesStartArray)sliceArray);
            }
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAttribute = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
            PayloadAttribute payloadAtt = this.storePayloads ? (PayloadAttribute)stream.addAttribute(PayloadAttribute.class) : null;
            BytesRef ref = termAtt.getBytesRef();
            stream.reset();
            while (stream.incrementToken()) {
                termAtt.fillBytesRef();
                ++numTokens;
                int posIncr = posIncrAttribute.getPositionIncrement();
                if (posIncr == 0) {
                    ++numOverlapTokens;
                }
                pos += posIncr;
                int ord = terms.add(ref);
                if (ord < 0) {
                    ord = -ord - 1;
                    this.postingsWriter.reset(sliceArray.end[ord]);
                } else {
                    sliceArray.start[ord] = this.postingsWriter.startNewSlice();
                }
                int n = ord;
                sliceArray.freq[n] = sliceArray.freq[n] + 1;
                ++sumTotalTermFreq;
                this.postingsWriter.writeInt(pos);
                if (this.storeOffsets) {
                    this.postingsWriter.writeInt(offsetAtt.startOffset() + offset);
                    this.postingsWriter.writeInt(offsetAtt.endOffset() + offset);
                }
                if (this.storePayloads) {
                    BytesRef payload = payloadAtt.getPayload();
                    int pIndex = payload == null || payload.length == 0 ? -1 : this.payloadsBytesRefs.append(payload);
                    this.postingsWriter.writeInt(pIndex);
                }
                sliceArray.end[ord] = this.postingsWriter.getCurrentOffset();
            }
            stream.end();
            if (numTokens > 0) {
                this.fields.put(fieldName, new Info(fieldInfo, terms, sliceArray, numTokens, numOverlapTokens, boost, pos, offsetAtt.endOffset() + offset, sumTotalTermFreq));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSimilarity(Similarity similarity) {
        if (this.frozen) {
            throw new IllegalArgumentException("Cannot set Similarity when MemoryIndex is frozen");
        }
        if (this.normSimilarity == similarity) {
            return;
        }
        this.normSimilarity = similarity;
        for (Info info : this.fields.values()) {
            info.norms = null;
        }
    }

    public IndexSearcher createSearcher() {
        MemoryIndexReader reader = new MemoryIndexReader();
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        searcher.setSimilarity(this.normSimilarity);
        return searcher;
    }

    public void freeze() {
        this.frozen = true;
        for (Info info : this.fields.values()) {
            info.sortTerms();
            info.getNormDocValues();
        }
    }

    public float search(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        IndexSearcher searcher = this.createSearcher();
        try {
            float score;
            final float[] scores = new float[1];
            searcher.search(query, (Collector)new SimpleCollector(){
                private Scorer scorer;

                public void collect(int doc) throws IOException {
                    scores[0] = this.scorer.score();
                }

                public void setScorer(Scorer scorer) {
                    this.scorer = scorer;
                }

                public boolean needsScores() {
                    return true;
                }
            });
            float f = score = scores[0];
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(256);
        int sumPositions = 0;
        int sumTerms = 0;
        BytesRef spare = new BytesRef();
        for (Map.Entry<String, Info> entry : this.fields.entrySet()) {
            String fieldName = entry.getKey();
            Info info = entry.getValue();
            info.sortTerms();
            result.append(fieldName + ":\n");
            SliceByteStartArray sliceArray = info.sliceArray;
            int numPositions = 0;
            IntBlockPool.SliceReader postingsReader = new IntBlockPool.SliceReader(this.intBlockPool);
            for (int j = 0; j < info.terms.size(); ++j) {
                int iters;
                int ord = info.sortedTerms[j];
                info.terms.get(ord, spare);
                int freq = sliceArray.freq[ord];
                result.append("\t'" + spare + "':" + freq + ":");
                postingsReader.reset(sliceArray.start[ord], sliceArray.end[ord]);
                result.append(" [");
                int n = iters = this.storeOffsets ? 3 : 1;
                while (!postingsReader.endOfSlice()) {
                    result.append("(");
                    for (int k = 0; k < iters; ++k) {
                        result.append(postingsReader.readInt());
                        if (k >= iters - 1) continue;
                        result.append(", ");
                    }
                    result.append(")");
                    if (postingsReader.endOfSlice()) continue;
                    result.append(",");
                }
                result.append("]");
                result.append("\n");
                numPositions += freq;
            }
            result.append("\tterms=" + info.terms.size());
            result.append(", positions=" + numPositions);
            result.append("\n");
            sumPositions += numPositions;
            sumTerms += info.terms.size();
        }
        result.append("\nfields=" + this.fields.size());
        result.append(", terms=" + sumTerms);
        result.append(", positions=" + sumPositions);
        return result.toString();
    }

    public void reset() {
        this.fields.clear();
        this.normSimilarity = IndexSearcher.getDefaultSimilarity();
        this.byteBlockPool.reset(false, false);
        this.intBlockPool.reset(true, false);
        if (this.payloadsBytesRefs != null) {
            this.payloadsBytesRefs.clear();
        }
        this.frozen = false;
    }

    private static final class SliceByteStartArray
    extends BytesRefHash.DirectBytesStartArray {
        int[] start;
        int[] end;
        int[] freq;

        public SliceByteStartArray(int initSize) {
            super(initSize);
        }

        public int[] init() {
            int[] ord = super.init();
            this.start = new int[ArrayUtil.oversize((int)ord.length, (int)4)];
            this.end = new int[ArrayUtil.oversize((int)ord.length, (int)4)];
            this.freq = new int[ArrayUtil.oversize((int)ord.length, (int)4)];
            assert (this.start.length >= ord.length);
            assert (this.end.length >= ord.length);
            assert (this.freq.length >= ord.length);
            return ord;
        }

        public int[] grow() {
            int[] ord = super.grow();
            if (this.start.length < ord.length) {
                this.start = ArrayUtil.grow((int[])this.start, (int)ord.length);
                this.end = ArrayUtil.grow((int[])this.end, (int)ord.length);
                this.freq = ArrayUtil.grow((int[])this.freq, (int)ord.length);
            }
            assert (this.start.length >= ord.length);
            assert (this.end.length >= ord.length);
            assert (this.freq.length >= ord.length);
            return ord;
        }

        public int[] clear() {
            this.end = null;
            this.start = null;
            return super.clear();
        }
    }

    private final class MemoryIndexReader
    extends LeafReader {
        private MemoryIndexReader() {
        }

        public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
            MemoryIndexReader.addCoreClosedListenerAsReaderClosedListener((IndexReader)this, (LeafReader.CoreClosedListener)listener);
        }

        public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
            MemoryIndexReader.removeCoreClosedListenerAsReaderClosedListener((IndexReader)this, (LeafReader.CoreClosedListener)listener);
        }

        private Info getInfo(String fieldName) {
            return (Info)MemoryIndex.this.fields.get(fieldName);
        }

        public Bits getLiveDocs() {
            return null;
        }

        public FieldInfos getFieldInfos() {
            FieldInfo[] fieldInfos = new FieldInfo[MemoryIndex.this.fields.size()];
            int i = 0;
            for (Info info : MemoryIndex.this.fields.values()) {
                fieldInfos[i++] = info.fieldInfo;
            }
            return new FieldInfos(fieldInfos);
        }

        public NumericDocValues getNumericDocValues(String field) {
            return null;
        }

        public BinaryDocValues getBinaryDocValues(String field) {
            return null;
        }

        public SortedDocValues getSortedDocValues(String field) {
            return null;
        }

        public SortedNumericDocValues getSortedNumericDocValues(String field) {
            return null;
        }

        public SortedSetDocValues getSortedSetDocValues(String field) {
            return null;
        }

        public Bits getDocsWithField(String field) throws IOException {
            return null;
        }

        public void checkIntegrity() throws IOException {
        }

        public Fields fields() {
            return new MemoryFields();
        }

        public Fields getTermVectors(int docID) {
            if (docID == 0) {
                return this.fields();
            }
            return null;
        }

        public int numDocs() {
            return 1;
        }

        public int maxDoc() {
            return 1;
        }

        public void document(int docID, StoredFieldVisitor visitor) {
        }

        protected void doClose() {
        }

        public NumericDocValues getNormValues(String field) {
            Info info = (Info)MemoryIndex.this.fields.get(field);
            if (info == null) {
                return null;
            }
            return info.getNormDocValues();
        }

        private class MemoryPostingsEnum
        extends PostingsEnum {
            private final IntBlockPool.SliceReader sliceReader;
            private int posUpto;
            private boolean hasNext;
            private Bits liveDocs;
            private int doc = -1;
            private int freq;
            private int pos;
            private int startOffset;
            private int endOffset;
            private int payloadIndex;
            private final BytesRefBuilder payloadBuilder;

            public MemoryPostingsEnum() {
                this.sliceReader = new IntBlockPool.SliceReader(MemoryIndex.this.intBlockPool);
                this.payloadBuilder = MemoryIndex.this.storePayloads ? new BytesRefBuilder() : null;
            }

            public PostingsEnum reset(Bits liveDocs, int start, int end, int freq) {
                this.liveDocs = liveDocs;
                this.sliceReader.reset(start, end);
                this.posUpto = 0;
                this.hasNext = true;
                this.doc = -1;
                this.freq = freq;
                return this;
            }

            public int docID() {
                return this.doc;
            }

            public int nextDoc() {
                this.pos = -1;
                if (this.hasNext && (this.liveDocs == null || this.liveDocs.get(0))) {
                    this.hasNext = false;
                    this.doc = 0;
                    return 0;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            public int advance(int target) throws IOException {
                return this.slowAdvance(target);
            }

            public int freq() throws IOException {
                return this.freq;
            }

            public int nextPosition() {
                ++this.posUpto;
                assert (this.posUpto <= this.freq);
                assert (!this.sliceReader.endOfSlice()) : " stores offsets : " + this.startOffset;
                int pos = this.sliceReader.readInt();
                if (MemoryIndex.this.storeOffsets) {
                    this.startOffset = this.sliceReader.readInt();
                    this.endOffset = this.sliceReader.readInt();
                }
                if (MemoryIndex.this.storePayloads) {
                    this.payloadIndex = this.sliceReader.readInt();
                }
                return pos;
            }

            public int startOffset() {
                return this.startOffset;
            }

            public int endOffset() {
                return this.endOffset;
            }

            public BytesRef getPayload() {
                if (this.payloadBuilder == null || this.payloadIndex == -1) {
                    return null;
                }
                return MemoryIndex.this.payloadsBytesRefs.get(this.payloadBuilder, this.payloadIndex);
            }

            public long cost() {
                return 1L;
            }
        }

        private class MemoryTermsEnum
        extends TermsEnum {
            private final Info info;
            private final BytesRef br = new BytesRef();
            int termUpto = -1;

            public MemoryTermsEnum(Info info) {
                this.info = info;
                info.sortTerms();
            }

            private final int binarySearch(BytesRef b, BytesRef bytesRef, int low, int high, BytesRefHash hash, int[] ords, Comparator<BytesRef> comparator) {
                int mid = 0;
                while (low <= high) {
                    mid = low + high >>> 1;
                    hash.get(ords[mid], bytesRef);
                    int cmp = comparator.compare(bytesRef, b);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                assert (comparator.compare(bytesRef, b) != 0);
                return -(low + 1);
            }

            public boolean seekExact(BytesRef text) {
                this.termUpto = this.binarySearch(text, this.br, 0, this.info.terms.size() - 1, this.info.terms, this.info.sortedTerms, BytesRef.getUTF8SortedAsUnicodeComparator());
                return this.termUpto >= 0;
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef text) {
                this.termUpto = this.binarySearch(text, this.br, 0, this.info.terms.size() - 1, this.info.terms, this.info.sortedTerms, BytesRef.getUTF8SortedAsUnicodeComparator());
                if (this.termUpto < 0) {
                    this.termUpto = -this.termUpto - 1;
                    if (this.termUpto >= this.info.terms.size()) {
                        return TermsEnum.SeekStatus.END;
                    }
                    this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                return TermsEnum.SeekStatus.FOUND;
            }

            public void seekExact(long ord) {
                assert (ord < (long)this.info.terms.size());
                this.termUpto = (int)ord;
                this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
            }

            public BytesRef next() {
                ++this.termUpto;
                if (this.termUpto >= this.info.terms.size()) {
                    return null;
                }
                this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
                return this.br;
            }

            public BytesRef term() {
                return this.br;
            }

            public long ord() {
                return this.termUpto;
            }

            public int docFreq() {
                return 1;
            }

            public long totalTermFreq() {
                return ((Info)this.info).sliceArray.freq[this.info.sortedTerms[this.termUpto]];
            }

            public PostingsEnum postings(Bits liveDocs, PostingsEnum reuse, int flags) {
                if (reuse == null || !(reuse instanceof MemoryPostingsEnum)) {
                    reuse = new MemoryPostingsEnum();
                }
                int ord = this.info.sortedTerms[this.termUpto];
                return ((MemoryPostingsEnum)reuse).reset(liveDocs, ((Info)this.info).sliceArray.start[ord], ((Info)this.info).sliceArray.end[ord], ((Info)this.info).sliceArray.freq[ord]);
            }

            public void seekExact(BytesRef term, TermState state) throws IOException {
                assert (state != null);
                this.seekExact(((OrdTermState)state).ord);
            }

            public TermState termState() throws IOException {
                OrdTermState ts = new OrdTermState();
                ts.ord = this.termUpto;
                return ts;
            }
        }

        private class MemoryFields
        extends Fields {
            private MemoryFields() {
            }

            public Iterator<String> iterator() {
                return MemoryIndex.this.fields.keySet().iterator();
            }

            public Terms terms(String field) {
                final Info info = (Info)MemoryIndex.this.fields.get(field);
                if (info == null) {
                    return null;
                }
                return new Terms(){

                    public TermsEnum iterator() {
                        return new MemoryTermsEnum(info);
                    }

                    public long size() {
                        return info.terms.size();
                    }

                    public long getSumTotalTermFreq() {
                        return info.sumTotalTermFreq;
                    }

                    public long getSumDocFreq() {
                        return info.terms.size();
                    }

                    public int getDocCount() {
                        return this.size() > 0L ? 1 : 0;
                    }

                    public boolean hasFreqs() {
                        return true;
                    }

                    public boolean hasOffsets() {
                        return MemoryIndex.this.storeOffsets;
                    }

                    public boolean hasPositions() {
                        return true;
                    }

                    public boolean hasPayloads() {
                        return MemoryIndex.this.storePayloads;
                    }
                };
            }

            public int size() {
                return MemoryIndex.this.fields.size();
            }
        }
    }

    private final class Info {
        private final FieldInfo fieldInfo;
        private transient NumericDocValues norms;
        private final BytesRefHash terms;
        private final SliceByteStartArray sliceArray;
        private transient int[] sortedTerms;
        private final int numTokens;
        private final int numOverlapTokens;
        private final float boost;
        private final long sumTotalTermFreq;
        private final int lastPosition;
        private final int lastOffset;

        public Info(FieldInfo fieldInfo, BytesRefHash terms, SliceByteStartArray sliceArray, int numTokens, int numOverlapTokens, float boost, int lastPosition, int lastOffset, long sumTotalTermFreq) {
            this.fieldInfo = fieldInfo;
            this.terms = terms;
            this.sliceArray = sliceArray;
            this.numTokens = numTokens;
            this.numOverlapTokens = numOverlapTokens;
            this.boost = boost;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.lastPosition = lastPosition;
            this.lastOffset = lastOffset;
        }

        public void sortTerms() {
            if (this.sortedTerms == null) {
                this.sortedTerms = this.terms.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
            }
        }

        public NumericDocValues getNormDocValues() {
            if (this.norms == null) {
                FieldInvertState invertState = new FieldInvertState(this.fieldInfo.name, this.fieldInfo.number, this.numTokens, this.numOverlapTokens, 0, this.boost);
                final long value = MemoryIndex.this.normSimilarity.computeNorm(invertState);
                this.norms = new NumericDocValues(){

                    public long get(int docID) {
                        if (docID != 0) {
                            throw new IndexOutOfBoundsException();
                        }
                        return value;
                    }
                };
            }
            return this.norms;
        }
    }
}

