/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.idversion;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

class SingleDocsEnum
extends PostingsEnum {
    private int doc;
    private int singleDocID;
    private Bits liveDocs;

    SingleDocsEnum() {
    }

    public void reset(int singleDocID, Bits liveDocs) {
        this.doc = -1;
        this.liveDocs = liveDocs;
        this.singleDocID = singleDocID;
    }

    public int nextDoc() {
        this.doc = this.doc == -1 && (this.liveDocs == null || this.liveDocs.get(this.singleDocID)) ? this.singleDocID : Integer.MAX_VALUE;
        return this.doc;
    }

    public int docID() {
        return this.doc;
    }

    public int advance(int target) {
        this.doc = this.doc == -1 && target <= this.singleDocID && (this.liveDocs == null || this.liveDocs.get(this.singleDocID)) ? this.singleDocID : Integer.MAX_VALUE;
        return this.doc;
    }

    public long cost() {
        return 1L;
    }

    public int freq() {
        return 1;
    }

    public int nextPosition() throws IOException {
        return -1;
    }

    public int startOffset() throws IOException {
        return -1;
    }

    public int endOffset() throws IOException {
        return -1;
    }

    public BytesRef getPayload() throws IOException {
        throw new UnsupportedOperationException();
    }
}

