/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry;

import org.apache.lucene.spatial.geometry.CartesianPoint;
import org.apache.lucene.spatial.geometry.DistanceUnits;
import org.apache.lucene.spatial.geometry.FixedLatLng;
import org.apache.lucene.spatial.geometry.FloatLatLng;

public abstract class LatLng {
    public abstract boolean isNormalized();

    public abstract boolean isFixedPoint();

    public abstract LatLng normalize();

    public abstract int getFixedLat();

    public abstract int getFixedLng();

    public abstract double getLat();

    public abstract double getLng();

    public abstract LatLng copy();

    public abstract FixedLatLng toFixed();

    public abstract FloatLatLng toFloat();

    public CartesianPoint toCartesian() {
        LatLng ll = this.normalize();
        int lat = ll.getFixedLat();
        int lng = ll.getFixedLng();
        return new CartesianPoint(lng + 180000000, lat + 90000000);
    }

    public static LatLng fromCartesian(CartesianPoint pt) {
        int lat = pt.getY() - 90000000;
        int lng = pt.getX() - 180000000;
        return new FixedLatLng(lat, lng);
    }

    public double arcDistance(LatLng ll2) {
        return this.arcDistance(ll2, DistanceUnits.MILES);
    }

    public double arcDistance(LatLng ll2, DistanceUnits lUnits) {
        double radius;
        LatLng ll1 = this.normalize();
        ll2 = ll2.normalize();
        double lat1 = ll1.getLat();
        double lng1 = ll1.getLng();
        double lat2 = ll2.getLat();
        double lng2 = ll2.getLng();
        if (lat1 == lat2 && lng1 == lng2) {
            return 0.0;
        }
        double dLon = lng2 - lng1;
        double a = this.radians(90.0 - lat1);
        double c = this.radians(90.0 - lat2);
        double cosB = Math.cos(a) * Math.cos(c) + Math.sin(a) * Math.sin(c) * Math.cos(this.radians(dLon));
        double d = radius = lUnits == DistanceUnits.MILES ? 3963.205 : 6378.160187;
        if (cosB < -1.0) {
            return Math.PI * radius;
        }
        if (cosB >= 1.0) {
            return 0.0;
        }
        return Math.acos(cosB) * radius;
    }

    private double radians(double a) {
        return a * 0.01745329251994;
    }

    public String toString() {
        return "[" + this.getLat() + "," + this.getLng() + "]";
    }

    public abstract LatLng calculateMidpoint(LatLng var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

