/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene3x;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

class PreFlexRWNormsConsumer
extends DocValuesConsumer {
    private static final byte[] NORMS_HEADER = new byte[]{78, 82, 77, -1};
    private static final String NORMS_EXTENSION = "nrm";
    @Deprecated
    private static final String SEPARATE_NORMS_EXTENSION = "s";
    private final IndexOutput out;
    private int lastFieldNumber = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreFlexRWNormsConsumer(Directory directory, String segment, IOContext context) throws IOException {
        String normsFileName = IndexFileNames.segmentFileName((String)segment, (String)"", (String)NORMS_EXTENSION);
        boolean success = false;
        IndexOutput output = null;
        try {
            output = directory.createOutput(normsFileName, context);
            output.writeBytes(NORMS_HEADER, 0, NORMS_HEADER.length);
            this.out = output;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
            throw throwable;
        }
    }

    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        assert (field.number > this.lastFieldNumber) : "writing norms fields out of order" + this.lastFieldNumber + " -> " + field.number;
        for (Number n : values) {
            if (n.longValue() < -128L || n.longValue() > 127L) {
                throw new UnsupportedOperationException("3.x cannot index norms that won't fit in a byte, got: " + n.longValue());
            }
            this.out.writeByte(n.byteValue());
        }
        this.lastFieldNumber = field.number;
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.out});
    }

    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        throw new AssertionError();
    }

    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        throw new AssertionError();
    }

    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        throw new AssertionError();
    }
}

