/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.mocksep;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.sep.IntIndexOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

public class MockSingleIntIndexOutput
extends IntIndexOutput {
    private final IndexOutput out;
    static final String CODEC = "SINGLE_INTS";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MockSingleIntIndexOutput(Directory dir, String fileName, IOContext context) throws IOException {
        this.out = dir.createOutput(fileName, context);
        boolean success = false;
        try {
            CodecUtil.writeHeader((DataOutput)this.out, (String)CODEC, (int)0);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
    }

    public void write(int v) throws IOException {
        this.out.writeVInt(v);
    }

    public IntIndexOutput.Index index() {
        return new MockSingleIntIndexOutputIndex();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public String toString() {
        return "MockSingleIntIndexOutput fp=" + this.out.getFilePointer();
    }

    private class MockSingleIntIndexOutputIndex
    extends IntIndexOutput.Index {
        long fp;
        long lastFP;

        private MockSingleIntIndexOutputIndex() {
        }

        public void mark() {
            this.fp = MockSingleIntIndexOutput.this.out.getFilePointer();
        }

        public void copyFrom(IntIndexOutput.Index other, boolean copyLast) {
            this.fp = ((MockSingleIntIndexOutputIndex)other).fp;
            if (copyLast) {
                this.lastFP = ((MockSingleIntIndexOutputIndex)other).fp;
            }
        }

        public void write(DataOutput indexOut, boolean absolute) throws IOException {
            if (absolute) {
                indexOut.writeVLong(this.fp);
            } else {
                indexOut.writeVLong(this.fp - this.lastFP);
            }
            this.lastFP = this.fp;
        }

        public String toString() {
            return Long.toString(this.fp);
        }
    }
}

