/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.maven.SessionScoped;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.MultiModuleSupport;
import org.apache.maven.buildcache.checksum.KeyUtils;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.buildcache.xml.config.Discovery;
import org.apache.maven.buildcache.xml.config.MultiModule;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named
public class DefaultMultiModuleSupport
implements MultiModuleSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultiModuleSupport.class);
    private final ProjectBuilder projectBuilder;
    private final CacheConfig cacheConfig;
    private final Provider<MavenSession> providerSession;
    private volatile boolean built;
    private volatile Map<String, MavenProject> projectMap;
    private volatile Map<String, MavenProject> sessionProjectMap;

    @Inject
    public DefaultMultiModuleSupport(ProjectBuilder projectBuilder, CacheConfig cacheConfig, Provider<MavenSession> providerSession) {
        this.projectBuilder = projectBuilder;
        this.cacheConfig = cacheConfig;
        this.providerSession = providerSession;
    }

    @Override
    public boolean isPartOfSession(String groupId, String artifactId, String version) {
        MavenSession session = (MavenSession)this.providerSession.get();
        return this.getProjectMap(session).containsKey(KeyUtils.getProjectKey(groupId, artifactId, version));
    }

    @Override
    public Optional<MavenProject> tryToResolveProject(String groupId, String artifactId, String version) {
        return Optional.ofNullable(this.getMultiModuleProjectsMap().get(KeyUtils.getProjectKey(groupId, artifactId, version)));
    }

    @Override
    public boolean isPartOfMultiModule(String groupId, String artifactId, String version) {
        String projectKey = KeyUtils.getProjectKey(groupId, artifactId, version);
        MavenSession session = (MavenSession)this.providerSession.get();
        return this.getProjectMap(session).containsKey(projectKey) || this.getMultiModuleProjectsMap().containsKey(projectKey);
    }

    private Map<String, MavenProject> getProjectMap(MavenSession session) {
        if (this.sessionProjectMap != null) {
            return this.sessionProjectMap;
        }
        this.sessionProjectMap = session.getProjects().stream().collect(Collectors.toMap(KeyUtils::getProjectKey, Function.identity()));
        return this.sessionProjectMap;
    }

    private Map<String, MavenProject> getMultiModuleProjectsMap() {
        if (this.projectMap != null) {
            return this.projectMap;
        }
        MavenSession session = (MavenSession)this.providerSession.get();
        return this.getMultiModuleProjectsMapInner(session);
    }

    private synchronized Map<String, MavenProject> getMultiModuleProjectsMapInner(MavenSession session) {
        if (this.projectMap != null) {
            return this.projectMap;
        }
        this.buildModel(session);
        return this.projectMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void buildModel(MavenSession session) {
        if (this.built) {
            return;
        }
        Optional<Discovery> multiModuleDiscovery = Optional.ofNullable(this.cacheConfig.getMultiModule()).map(MultiModule::getDiscovery);
        if (!multiModuleDiscovery.isPresent()) {
            this.projectMap = this.buildProjectMap(session.getProjects());
            return;
        }
        TreeSet scanProfiles = new TreeSet(multiModuleDiscovery.map(Discovery::getScanProfiles).orElse(Collections.emptyList()));
        MavenProject currentProject = session.getCurrentProject();
        File multiModulePomFile = DefaultMultiModuleSupport.getMultiModulePomFile(session);
        ProjectBuildingRequest projectBuildingRequest = currentProject.getProjectBuildingRequest();
        boolean profilesMatched = new HashSet(projectBuildingRequest.getActiveProfileIds()).containsAll(scanProfiles);
        if (currentProject.getFile().getAbsolutePath().equals(multiModulePomFile.getAbsolutePath()) && profilesMatched) {
            this.projectMap = this.buildProjectMap(session.getProjects());
            return;
        }
        long t0 = System.currentTimeMillis();
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(projectBuildingRequest);
        buildingRequest.setProfiles(buildingRequest.getProfiles().stream().peek(it -> it.setProperties(new Properties())).collect(Collectors.toList()));
        if (!profilesMatched) {
            LinkedHashSet profiles = new LinkedHashSet(buildingRequest.getActiveProfileIds());
            profiles.addAll(scanProfiles);
            buildingRequest.setActiveProfileIds(new ArrayList(profiles));
        }
        try {
            List buildingResults = this.projectBuilder.build(Collections.singletonList(multiModulePomFile), true, (ProjectBuildingRequest)buildingRequest);
            LOGGER.info("Multi module project model calculated [activeProfiles={}, time={} ms ", (Object)buildingRequest.getActiveProfileIds(), (Object)(System.currentTimeMillis() - t0));
            List<MavenProject> projectList = buildingResults.stream().map(ProjectBuildingResult::getProject).collect(Collectors.toList());
            this.projectMap = this.buildProjectMap(projectList);
        }
        catch (ProjectBuildingException e) {
            LOGGER.error("Unable to build model", (Throwable)e);
        }
        finally {
            this.built = true;
        }
    }

    private Map<String, MavenProject> buildProjectMap(List<MavenProject> projectList) {
        return projectList.stream().collect(Collectors.toMap(KeyUtils::getProjectKey, Function.identity()));
    }

    private static File getMultiModulePomFile(MavenSession session) {
        return CacheUtils.getMultimoduleRoot(session).resolve("pom.xml").toFile();
    }
}

