/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.backend.smo.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.search.api.MAVEN;
import org.apache.maven.search.api.Record;
import org.apache.maven.search.api.SearchRequest;
import org.apache.maven.search.api.request.BooleanQuery;
import org.apache.maven.search.api.request.Field;
import org.apache.maven.search.api.request.FieldQuery;
import org.apache.maven.search.api.request.Query;
import org.apache.maven.search.api.support.SearchBackendSupport;
import org.apache.maven.search.api.transport.Transport;
import org.apache.maven.search.backend.smo.SmoSearchBackend;
import org.apache.maven.search.backend.smo.SmoSearchResponse;
import org.apache.maven.search.backend.smo.internal.SmoSearchResponseImpl;

public class SmoSearchBackendImpl
extends SearchBackendSupport
implements SmoSearchBackend {
    protected static final Map<Field, String> FIELD_TRANSLATION = Map.of(MAVEN.GROUP_ID, "g", MAVEN.ARTIFACT_ID, "a", MAVEN.VERSION, "v", MAVEN.CLASSIFIER, "l", MAVEN.PACKAGING, "p", MAVEN.CLASS_NAME, "c", MAVEN.FQ_CLASS_NAME, "fc", MAVEN.SHA1, "1");
    protected final String smoUri;
    protected final Transport transport;
    protected final Map<String, String> commonHeaders;
    protected static final JsonPrimitive EC_SOURCE_JAR = new JsonPrimitive("-sources.jar");
    protected static final JsonPrimitive EC_JAVADOC_JAR = new JsonPrimitive("-javadoc.jar");

    public SmoSearchBackendImpl(String backendId, String repositoryId, String smoUri, Transport transport) {
        super(backendId, repositoryId);
        this.smoUri = Objects.requireNonNull(smoUri);
        this.transport = Objects.requireNonNull(transport);
        this.commonHeaders = new HashMap<String, String>();
        this.commonHeaders.put("User-Agent", "Apache-Maven-Search-SMO/" + this.discoverVersion() + " " + transport.getClass().getSimpleName());
        this.commonHeaders.put("Accept", "application/json");
    }

    protected String discoverVersion() {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/apache/maven/search/backend/smo/internal/smo-version.properties");
        if (inputStream != null) {
            try (InputStream is = inputStream;){
                properties.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties.getProperty("version", "unknown");
    }

    @Override
    public String getSmoUri() {
        return this.smoUri;
    }

    @Override
    public SmoSearchResponse search(SearchRequest searchRequest) throws IOException {
        String searchUri = this.toURI(searchRequest);
        String payload = this.fetch(searchUri, this.commonHeaders);
        JsonObject raw = JsonParser.parseString((String)payload).getAsJsonObject();
        ArrayList<Record> page = new ArrayList<Record>(searchRequest.getPaging().getPageSize());
        int totalHits = this.populateFromRaw(raw, page);
        return new SmoSearchResponseImpl(searchRequest, totalHits, page, searchUri, payload);
    }

    protected String toURI(SearchRequest searchRequest) {
        HashSet<Field> searchedFields = new HashSet<Field>();
        Object smoQuery = this.toSMOQuery(searchedFields, searchRequest.getQuery());
        smoQuery = (String)smoQuery + this.paging(searchRequest, searchedFields);
        smoQuery = (String)smoQuery + this.extra(searchRequest, searchedFields);
        return this.smoUri + "?q=" + (String)smoQuery;
    }

    protected String paging(SearchRequest searchRequest, HashSet<Field> searchedFields) {
        if ("central-csc".equals(this.backendId)) {
            return this.cscPaging(searchRequest, searchedFields);
        }
        return this.smoPaging(searchRequest, searchedFields);
    }

    protected String smoPaging(SearchRequest searchRequest, HashSet<Field> searchedFields) {
        return "&start=" + searchRequest.getPaging().getPageSize() * searchRequest.getPaging().getPageOffset() + "&rows=" + searchRequest.getPaging().getPageSize();
    }

    protected String cscPaging(SearchRequest searchRequest, HashSet<Field> searchedFields) {
        return "&start=" + searchRequest.getPaging().getPageOffset() + "&rows=" + searchRequest.getPaging().getPageSize();
    }

    protected String extra(SearchRequest searchRequest, HashSet<Field> searchedFields) {
        Object extra = "&wt=json";
        if (searchedFields.contains(MAVEN.GROUP_ID) && searchedFields.contains(MAVEN.ARTIFACT_ID)) {
            extra = (String)extra + "&core=gav";
        }
        return extra;
    }

    protected String fetch(String serviceUri, Map<String, String> headers) throws IOException {
        try (Transport.Response response = this.transport.get(serviceUri, headers);){
            if (response.getCode() == 200) {
                String string = new String(response.getBody().readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
            throw new IOException("Unexpected response: " + String.valueOf(response));
        }
    }

    protected String toSMOQuery(HashSet<Field> searchedFields, Query query) {
        if (query instanceof BooleanQuery.And) {
            BooleanQuery bq = (BooleanQuery)query;
            return this.toSMOQuery(searchedFields, bq.getLeft()) + "%20AND%20" + this.toSMOQuery(searchedFields, bq.getRight());
        }
        if (query instanceof FieldQuery) {
            FieldQuery fq = (FieldQuery)query;
            String smoFieldName = FIELD_TRANSLATION.get(fq.getField());
            if (smoFieldName != null) {
                searchedFields.add(fq.getField());
                return smoFieldName + ":" + this.encodeQueryParameterValue(fq.getValue());
            }
            throw new IllegalArgumentException("Unsupported SMO field: " + String.valueOf(fq.getField()));
        }
        return this.encodeQueryParameterValue(query.getValue());
    }

    protected String encodeQueryParameterValue(String parameterValue) {
        return URLEncoder.encode(parameterValue, StandardCharsets.UTF_8).replace("+", "%20");
    }

    protected int populateFromRaw(JsonObject raw, List<Record> page) {
        JsonObject response = raw.getAsJsonObject("response");
        Number numFound = response.get("numFound").getAsNumber();
        JsonArray docs = response.getAsJsonArray("docs");
        for (JsonElement doc : docs) {
            page.add(this.convert((JsonObject)doc));
        }
        return numFound.intValue();
    }

    protected Record convert(JsonObject doc) {
        JsonArray ec;
        Number versionCount;
        HashMap<Field, Object> result = new HashMap<Field, Object>();
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.GROUP_ID, SmoSearchBackendImpl.mayGet("g", doc));
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.ARTIFACT_ID, SmoSearchBackendImpl.mayGet("a", doc));
        String version = SmoSearchBackendImpl.mayGet("v", doc);
        if (version == null) {
            version = SmoSearchBackendImpl.mayGet("latestVersion", doc);
        }
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.VERSION, version);
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.PACKAGING, SmoSearchBackendImpl.mayGet("p", doc));
        SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.CLASSIFIER, SmoSearchBackendImpl.mayGet("l", doc));
        Number number = versionCount = doc.has("versionCount") ? (Number)doc.get("versionCount").getAsNumber() : (Number)null;
        if (versionCount != null) {
            SmoSearchBackendImpl.mayPut(result, (Field)MAVEN.VERSION_COUNT, versionCount.intValue());
        }
        if ((ec = doc.getAsJsonArray("ec")) != null) {
            result.put((Field)MAVEN.HAS_SOURCE, ec.contains((JsonElement)EC_SOURCE_JAR));
            result.put((Field)MAVEN.HAS_JAVADOC, ec.contains((JsonElement)EC_JAVADOC_JAR));
        }
        return new Record(this.getBackendId(), this.getRepositoryId(), doc.has("id") ? doc.get("id").getAsString() : null, doc.has("timestamp") ? Long.valueOf(doc.get("timestamp").getAsLong()) : null, result);
    }

    protected static String mayGet(String field, JsonObject object) {
        return object.has(field) ? object.get(field).getAsString() : null;
    }

    protected static void mayPut(Map<Field, Object> result, Field fieldName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String && ((String)value).trim().isEmpty()) {
            return;
        }
        result.put(fieldName, value);
    }
}

