/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.artifact.buildinfo;

import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.artifact.buildinfo.AbstractBuildinfoMojo;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.toolchain.ToolchainManager;
import org.eclipse.aether.artifact.Artifact;

@Mojo(name="buildinfo", defaultPhase=LifecyclePhase.VERIFY, threadSafe=false)
public class BuildinfoMojo
extends AbstractBuildinfoMojo {
    @Parameter(property="buildinfo.attach", defaultValue="true")
    private boolean attach;
    private final MavenProjectHelper projectHelper;

    @Inject
    public BuildinfoMojo(ToolchainManager toolchainManager, RuntimeInformation runtimeInformation, MavenProject project, MavenSession session, MavenProjectHelper projectHelper) {
        super(toolchainManager, runtimeInformation, project, session);
        this.projectHelper = projectHelper;
    }

    @Override
    public void execute(Map<Artifact, String> artifacts) throws MojoExecutionException {
        if (this.attach) {
            this.getLog().info((CharSequence)"Attaching buildinfo");
            this.projectHelper.attachArtifact(this.project, "buildinfo", this.buildinfoFile);
        } else {
            this.getLog().info((CharSequence)"NOT adding buildinfo to the list of attached artifacts.");
        }
    }
}

