/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.junit.runners.model.RunnerScheduler;

public class AsynchronousRunner
implements RunnerScheduler {
    private final List<Future<Object>> futures = Collections.synchronizedList(new ArrayList());
    private final ExecutorService fService;

    public AsynchronousRunner(ExecutorService fService) {
        this.fService = fService;
    }

    public void schedule(Runnable childStatement) {
        this.futures.add(this.fService.submit(Executors.callable(childStatement)));
    }

    public void finished() {
        try {
            this.waitForCompletion();
        }
        catch (ExecutionException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    public void waitForCompletion() throws ExecutionException {
        for (Future<Object> each : this.futures) {
            try {
                each.get();
            }
            catch (InterruptedException e) {
                throw new NestedRuntimeException((Throwable)e);
            }
        }
    }
}

