/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.surefire.junitcore.JUnitCoreParameters;
import org.apache.maven.surefire.junitcore.pc.Balancer;
import org.apache.maven.surefire.junitcore.pc.BalancerFactory;
import org.apache.maven.surefire.junitcore.pc.Concurrency;
import org.apache.maven.surefire.junitcore.pc.InvokerStrategy;
import org.apache.maven.surefire.junitcore.pc.ParallelComputer;
import org.apache.maven.surefire.junitcore.pc.ParallelComputerUtil;
import org.apache.maven.surefire.junitcore.pc.RunnerCounter;
import org.apache.maven.surefire.junitcore.pc.Scheduler;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategies;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.junitcore.pc.SharedThreadPoolStrategy;
import org.apache.maven.surefire.junitcore.pc.Type;
import org.apache.maven.surefire.junitcore.pc.WrappedRunners;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.RunnerScheduler;

public final class ParallelComputerBuilder {
    static final int TOTAL_POOL_SIZE_UNDEFINED = 0;
    private final Map<Type, Integer> parallelGroups = new EnumMap<Type, Integer>(Type.class);
    private boolean useSeparatePools;
    private int totalPoolSize;
    private JUnitCoreParameters parameters;
    private boolean optimize;
    private boolean runningInTests = true;

    ParallelComputerBuilder() {
        this.useSeparatePools();
        this.parallelGroups.put(Type.SUITES, 0);
        this.parallelGroups.put(Type.CLASSES, 0);
        this.parallelGroups.put(Type.METHODS, 0);
    }

    public ParallelComputerBuilder(JUnitCoreParameters parameters) {
        this();
        this.runningInTests = false;
        this.parameters = parameters;
    }

    public ParallelComputer buildComputer() {
        return new PC();
    }

    ParallelComputerBuilder useSeparatePools() {
        this.totalPoolSize = 0;
        this.useSeparatePools = true;
        return this;
    }

    ParallelComputerBuilder useOnePool() {
        this.totalPoolSize = 0;
        this.useSeparatePools = false;
        return this;
    }

    ParallelComputerBuilder useOnePool(int totalPoolSize) {
        if (totalPoolSize < 1) {
            throw new IllegalArgumentException("Size of common pool is less than 1.");
        }
        this.totalPoolSize = totalPoolSize;
        this.useSeparatePools = false;
        return this;
    }

    boolean isOptimized() {
        return this.optimize;
    }

    ParallelComputerBuilder optimize(boolean optimize) {
        this.optimize = optimize;
        return this;
    }

    ParallelComputerBuilder parallelSuites() {
        return this.parallel(Type.SUITES);
    }

    ParallelComputerBuilder parallelSuites(int nThreads) {
        return this.parallel(nThreads, Type.SUITES);
    }

    ParallelComputerBuilder parallelClasses() {
        return this.parallel(Type.CLASSES);
    }

    ParallelComputerBuilder parallelClasses(int nThreads) {
        return this.parallel(nThreads, Type.CLASSES);
    }

    ParallelComputerBuilder parallelMethods() {
        return this.parallel(Type.METHODS);
    }

    ParallelComputerBuilder parallelMethods(int nThreads) {
        return this.parallel(nThreads, Type.METHODS);
    }

    private ParallelComputerBuilder parallel(int nThreads, Type parallelType) {
        if (nThreads < 0) {
            throw new IllegalArgumentException("negative nThreads " + nThreads);
        }
        if (parallelType == null) {
            throw new NullPointerException("null parallelType");
        }
        this.parallelGroups.put(parallelType, nThreads);
        return this;
    }

    private ParallelComputerBuilder parallel(Type parallelType) {
        return this.parallel(Integer.MAX_VALUE, parallelType);
    }

    private double parallelTestsTimeoutInSeconds() {
        return this.parameters == null ? 0.0 : this.parameters.getParallelTestsTimeoutInSeconds();
    }

    private double parallelTestsTimeoutForcedInSeconds() {
        return this.parameters == null ? 0.0 : this.parameters.getParallelTestsTimeoutForcedInSeconds();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PC
    extends ParallelComputer {
        final Collection<ParentRunner> suites;
        final Collection<ParentRunner> nestedSuites;
        final Collection<ParentRunner> classes;
        final Collection<ParentRunner> nestedClasses;
        final Collection<Runner> unscheduledRunners;
        int poolCapacity;
        boolean splitPool;
        private final Map<Type, Integer> allGroups;
        private long nestedClassesChildren;
        private volatile Scheduler master;

        private PC() {
            super(ParallelComputerBuilder.this.parallelTestsTimeoutInSeconds(), ParallelComputerBuilder.this.parallelTestsTimeoutForcedInSeconds());
            this.suites = new LinkedHashSet<ParentRunner>();
            this.nestedSuites = new LinkedHashSet<ParentRunner>();
            this.classes = new LinkedHashSet<ParentRunner>();
            this.nestedClasses = new LinkedHashSet<ParentRunner>();
            this.unscheduledRunners = new LinkedHashSet<Runner>();
            this.allGroups = new EnumMap<Type, Integer>(ParallelComputerBuilder.this.parallelGroups);
            this.poolCapacity = ParallelComputerBuilder.this.totalPoolSize;
            this.splitPool = ParallelComputerBuilder.this.useSeparatePools;
        }

        @Override
        public Collection<Description> shutdown(boolean shutdownNow) {
            Scheduler master = this.master;
            return master == null ? Collections.emptyList() : master.shutdown(shutdownNow);
        }

        public Runner getSuite(RunnerBuilder builder, Class<?>[] cls) throws InitializationError {
            try {
                super.getSuite(builder, (Class[])cls);
                this.populateChildrenFromSuites();
                WrappedRunners suiteSuites = this.wrapRunners(this.suites);
                WrappedRunners suiteClasses = this.wrapRunners(this.classes);
                long suitesCount = this.suites.size();
                long classesCount = this.classes.size() + this.nestedClasses.size();
                long methodsCount = suiteClasses.embeddedChildrenCount + this.nestedClassesChildren;
                if (!ParallelComputerBuilder.this.runningInTests) {
                    this.determineThreadCounts(suitesCount, classesCount, methodsCount);
                }
                return this.setSchedulers(suiteSuites.wrappingSuite, suiteClasses.wrappingSuite);
            }
            catch (TestSetFailedException e) {
                throw new InitializationError((Throwable)e);
            }
        }

        protected Runner getRunner(RunnerBuilder builder, Class<?> testClass) throws Throwable {
            Runner runner = super.getRunner(builder, testClass);
            if (this.canSchedule(runner)) {
                if (runner instanceof Suite) {
                    this.suites.add((ParentRunner)((Suite)runner));
                } else {
                    this.classes.add((ParentRunner)runner);
                }
            } else {
                this.unscheduledRunners.add(runner);
            }
            return runner;
        }

        private void determineThreadCounts(long suites, long classes, long methods) throws TestSetFailedException {
            JUnitCoreParameters parameters = ParallelComputerBuilder.this.parameters;
            boolean optimize = ParallelComputerBuilder.this.optimize;
            RunnerCounter counts = new RunnerCounter(suites, classes, methods);
            Concurrency concurrency = ParallelComputerUtil.resolveConcurrency(parameters, optimize ? counts : null);
            this.allGroups.put(Type.SUITES, concurrency.suites);
            this.allGroups.put(Type.CLASSES, concurrency.classes);
            this.allGroups.put(Type.METHODS, concurrency.methods);
            this.poolCapacity = concurrency.capacity;
            this.splitPool &= concurrency.capacity <= 0;
        }

        private <T extends Runner> WrappedRunners wrapRunners(Collection<T> runners) throws InitializationError {
            long childrenCounter = 0L;
            ArrayList<Runner> runs = new ArrayList<Runner>();
            for (Runner runner : runners) {
                if (runner == null) continue;
                int children = this.countChildren(runner);
                childrenCounter += (long)children;
                if (children == 0) continue;
                runs.add(runner);
            }
            Suite wrapper = runs.isEmpty() ? null : new Suite(null, runs){};
            return new WrappedRunners((ParentRunner)wrapper, childrenCounter);
        }

        private int countChildren(Runner runner) {
            Description description = runner.getDescription();
            ArrayList children = description == null ? null : description.getChildren();
            return children == null ? 0 : children.size();
        }

        private ExecutorService createPool(int poolSize) {
            return poolSize < Integer.MAX_VALUE ? Executors.newFixedThreadPool(poolSize) : Executors.newCachedThreadPool();
        }

        private Scheduler createMaster(ExecutorService pool, int poolSize) {
            if (!this.areSuitesAndClassesParallel() || poolSize <= 1) {
                return new Scheduler(null, new InvokerStrategy());
            }
            if (pool != null && poolSize == Integer.MAX_VALUE) {
                return new Scheduler(null, new SharedThreadPoolStrategy(pool));
            }
            return new Scheduler(null, SchedulingStrategies.createParallelStrategy(2));
        }

        private boolean areSuitesAndClassesParallel() {
            return !this.suites.isEmpty() && this.allGroups.get((Object)Type.SUITES) > 0 && !this.classes.isEmpty() && this.allGroups.get((Object)Type.CLASSES) > 0;
        }

        private void populateChildrenFromSuites() {
            SuiteFilter filter = new SuiteFilter();
            Iterator<ParentRunner> it = this.suites.iterator();
            while (it.hasNext()) {
                ParentRunner suite = it.next();
                try {
                    suite.filter((Filter)filter);
                }
                catch (NoTestsRemainException e) {
                    it.remove();
                }
            }
        }

        private int totalPoolSize() {
            if (this.poolCapacity == 0) {
                int total = 0;
                for (int nThreads : this.allGroups.values()) {
                    if ((total += nThreads) >= 0) continue;
                    total = Integer.MAX_VALUE;
                    break;
                }
                return total;
            }
            return this.poolCapacity;
        }

        private Runner setSchedulers(ParentRunner suiteSuites, ParentRunner suiteClasses) throws InitializationError {
            int parallelSuites = this.allGroups.get((Object)Type.SUITES);
            int parallelClasses = this.allGroups.get((Object)Type.CLASSES);
            int parallelMethods = this.allGroups.get((Object)Type.METHODS);
            int poolSize = this.totalPoolSize();
            ExecutorService commonPool = this.splitPool || poolSize == 0 ? null : this.createPool(poolSize);
            this.master = this.createMaster(commonPool, poolSize);
            if (suiteSuites != null) {
                if (commonPool != null && parallelSuites > 0) {
                    Balancer balancer = BalancerFactory.createBalancerWithFairness(parallelSuites);
                    suiteSuites.setScheduler((RunnerScheduler)this.createScheduler(null, commonPool, true, balancer));
                } else {
                    suiteSuites.setScheduler((RunnerScheduler)this.createScheduler(parallelSuites));
                }
            }
            ArrayList<ParentRunner> allSuites = new ArrayList<ParentRunner>(this.suites);
            allSuites.addAll(this.nestedSuites);
            if (suiteClasses != null) {
                allSuites.add(suiteClasses);
            }
            if (!allSuites.isEmpty()) {
                this.setSchedulers(allSuites, parallelClasses, commonPool);
            }
            ArrayList<ParentRunner> allClasses = new ArrayList<ParentRunner>(this.classes);
            allClasses.addAll(this.nestedClasses);
            if (!allClasses.isEmpty()) {
                this.setSchedulers(allClasses, parallelMethods, commonPool);
            }
            ParentRunner all = this.createFinalRunner(new Runner[]{suiteSuites, suiteClasses});
            all.setScheduler((RunnerScheduler)this.master);
            return all;
        }

        private ParentRunner createFinalRunner(Runner ... runners) throws InitializationError {
            ArrayList<Runner> all = new ArrayList<Runner>(this.unscheduledRunners);
            for (Runner runner : runners) {
                if (runner == null) continue;
                all.add(runner);
            }
            return new Suite(null, all){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(RunNotifier notifier) {
                    try {
                        PC.this.beforeRunQuietly();
                        super.run(notifier);
                    }
                    finally {
                        PC.this.afterRunQuietly();
                    }
                }
            };
        }

        private void setSchedulers(Iterable<? extends ParentRunner> runners, int poolSize, ExecutorService commonPool) {
            if (commonPool != null) {
                Balancer concurrencyLimit = BalancerFactory.createBalancerWithFairness(poolSize);
                boolean doParallel = poolSize > 0;
                for (ParentRunner parentRunner : runners) {
                    parentRunner.setScheduler((RunnerScheduler)this.createScheduler(parentRunner.getDescription(), commonPool, doParallel, concurrencyLimit));
                }
            } else {
                ExecutorService pool = null;
                if (poolSize == Integer.MAX_VALUE) {
                    pool = Executors.newCachedThreadPool();
                } else if (poolSize > 0) {
                    pool = Executors.newFixedThreadPool(poolSize);
                }
                boolean doParallel = pool != null;
                for (ParentRunner parentRunner : runners) {
                    parentRunner.setScheduler((RunnerScheduler)this.createScheduler(parentRunner.getDescription(), pool, doParallel, BalancerFactory.createInfinitePermitsBalancer()));
                }
            }
        }

        private Scheduler createScheduler(Description desc, ExecutorService pool, boolean doParallel, Balancer concurrency) {
            SchedulingStrategy strategy = (doParallel &= pool != null) ? new SharedThreadPoolStrategy(pool) : new InvokerStrategy();
            return new Scheduler(desc, this.master, strategy, concurrency);
        }

        private Scheduler createScheduler(int poolSize) {
            if (poolSize == Integer.MAX_VALUE) {
                return new Scheduler(null, this.master, SchedulingStrategies.createParallelStrategyUnbounded());
            }
            if (poolSize == 0) {
                return new Scheduler(null, this.master, new InvokerStrategy());
            }
            return new Scheduler(null, this.master, SchedulingStrategies.createParallelStrategy(poolSize));
        }

        private boolean canSchedule(Runner runner) {
            return !(runner instanceof ErrorReportingRunner) && runner instanceof ParentRunner;
        }

        private class SuiteFilter
        extends Filter {
            private SuiteFilter() {
            }

            public boolean shouldRun(Description description) {
                return true;
            }

            public void apply(Object child) throws NoTestsRemainException {
                super.apply(child);
                if (child instanceof Suite) {
                    PC.this.nestedSuites.add((ParentRunner)((Suite)child));
                } else if (child instanceof ParentRunner) {
                    ParentRunner parentRunner = (ParentRunner)child;
                    PC.this.nestedClasses.add(parentRunner);
                    PC.this.nestedClassesChildren += parentRunner.getDescription().getChildren().size();
                }
            }

            public String describe() {
                return "";
            }
        }
    }
}

