/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.maven.surefire.junitcore.pc.AbstractThreadPoolStrategy;

final class SharedThreadPoolStrategy
extends AbstractThreadPoolStrategy {
    SharedThreadPoolStrategy(ExecutorService threadPool) {
        super(threadPool, new ConcurrentLinkedQueue());
    }

    public boolean hasSharedThreadPool() {
        return true;
    }

    public boolean finished() throws InterruptedException {
        boolean wasRunningAll = this.canSchedule();
        for (Future<?> futureResult : this.getFutureResults()) {
            try {
                futureResult.get();
            }
            catch (InterruptedException e) {
                wasRunningAll = false;
            }
            catch (ExecutionException e) {
            }
            catch (CancellationException e) {}
        }
        this.disable();
        return wasRunningAll;
    }

    protected final boolean stop() {
        return this.stop(false);
    }

    protected final boolean stopNow() {
        return this.stop(true);
    }

    private boolean stop(boolean interrupt) {
        boolean wasRunning = this.canSchedule();
        for (Future<?> futureResult : this.getFutureResults()) {
            futureResult.cancel(interrupt);
        }
        this.disable();
        return wasRunning;
    }
}

