/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.concurrent.Semaphore;
import org.apache.maven.surefire.junitcore.pc.Balancer;

final class ThreadResourcesBalancer
implements Balancer {
    private final Semaphore balancer;
    private final int numPermits;

    ThreadResourcesBalancer(int numPermits) {
        this(numPermits, false);
    }

    ThreadResourcesBalancer(int numPermits, boolean fair) {
        this.balancer = new Semaphore(numPermits, fair);
        this.numPermits = numPermits;
    }

    public boolean acquirePermit() {
        try {
            this.balancer.acquire();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public void releasePermit() {
        this.balancer.release();
    }

    public void releaseAllPermits() {
        this.balancer.release(this.numPermits);
    }
}

