/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree2;

import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.component.LocationAware;
import org.apache.myfaces.custom.tree2.TreeWalker;
import org.apache.myfaces.custom.tree2.UITreeData;

public abstract class AbstractHtmlTree
extends UITreeData
implements LocationAware {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlTree2";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.HtmlTree2";
    private UICommand _expandControl = null;
    private boolean _clientSideToggle = true;
    private boolean _clientSideToggleSet;
    private String _varNodeToggler;

    public boolean isClientSideToggle() {
        if (this._clientSideToggleSet) {
            return this._clientSideToggle;
        }
        ValueBinding expression = this.getValueBinding("clientSideToggle");
        if (expression != null) {
            return (Boolean)expression.getValue(this.getFacesContext());
        }
        return true;
    }

    public void setClientSideToggle(boolean clientSideToggle) {
        this._clientSideToggle = clientSideToggle;
        this._clientSideToggleSet = true;
    }

    protected void processNodes(FacesContext context, int processAction, TreeWalker walker) {
        if (this.isClientSideToggle()) {
            walker.setCheckState(false);
        }
        super.processNodes(context, processAction, walker);
    }

    public void setNodeId(String nodeId) {
        super.setNodeId(nodeId);
        if (this._varNodeToggler != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            requestMap.put(this._varNodeToggler, this);
        }
    }

    public UICommand getExpandControl() {
        if (this._expandControl == null) {
            this._expandControl = new HtmlCommandLink();
            this._expandControl.setParent((UIComponent)this);
        }
        return this._expandControl;
    }

    public String getVarNodeToggler() {
        return this._varNodeToggler;
    }

    public void setVarNodeToggler(String varNodeToggler) {
        this._varNodeToggler = varNodeToggler;
        String bindingString = "#{" + varNodeToggler + ".toggleExpanded}";
        MethodBinding actionBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(bindingString, null);
        this.getExpandControl().setAction(actionBinding);
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{super.saveState(facesContext), this._varNodeToggler, this._clientSideToggle, this._clientSideToggleSet};
        return values;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(facesContext, values[0]);
        this._varNodeToggler = (String)values[1];
        this._clientSideToggle = (Boolean)values[2];
        this._clientSideToggleSet = (Boolean)values[3];
    }

    public abstract boolean isShowNav();

    public abstract boolean isShowLines();

    public abstract boolean isShowRootNode();

    public abstract boolean isPreserveToggle();
}

