/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.myfaces.component.html.ext._SerializableDataModel;

public class BaseSortableModel
extends DataModel {
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    protected DataModel _model = null;
    private Object _wrappedData = null;
    private IntList _sortedIndicesList = null;
    private IntList _baseIndicesList = null;
    private Comparator _comparator = null;
    private static final DataModel EMPTY_DATA_MODEL = new _SerializableDataModel(){

        public boolean isRowAvailable() {
            return false;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            throw new IllegalArgumentException();
        }

        public int getRowIndex() {
            return -1;
        }

        public void setRowIndex(int i) {
            if (i < -1) {
                throw new IndexOutOfBoundsException("Index < 0 : " + i);
            }
        }

        public Object getWrappedData() {
            return null;
        }

        public void setWrappedData(Object obj) {
            if (obj == null) {
                return;
            }
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    };

    public Comparator getComparator() {
        return this._comparator;
    }

    public void setComparator(Comparator comparator) {
        this._comparator = comparator;
        this.sort();
    }

    public BaseSortableModel(Object model) {
        this.setWrappedData(model);
    }

    public BaseSortableModel() {
    }

    public Object getRowData() {
        return this._model.getRowData();
    }

    public Object getWrappedData() {
        return this._wrappedData;
    }

    public boolean isRowAvailable() {
        return this._model.isRowAvailable();
    }

    public void setWrappedData(Object data) {
        this._baseIndicesList = null;
        this._model = this.toDataModel(data);
        this._sortedIndicesList = null;
        this._wrappedData = data;
    }

    protected DataModel toDataModel(Object data) {
        if (data == null) {
            return EMPTY_DATA_MODEL;
        }
        if (data instanceof DataModel) {
            return (DataModel)data;
        }
        if (data instanceof List) {
            return new ListDataModel((List)data);
        }
        if (data instanceof Collection) {
            return new ListDataModel(new ArrayList((Collection)data));
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(data.getClass())) {
            return new ArrayDataModel((Object[])data);
        }
        if (data instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)data);
        }
        if (data instanceof Result) {
            return new ResultDataModel((Result)data);
        }
        return new ScalarDataModel(data);
    }

    public int getRowCount() {
        return this._model.getRowCount();
    }

    public void setRowIndex(int rowIndex) {
        int baseIndex = this._toBaseIndex(rowIndex);
        this._model.setRowIndex(baseIndex);
    }

    public int getRowIndex() {
        int baseIndex = this._model.getRowIndex();
        return this._toSortedIndex(baseIndex);
    }

    public String toString() {
        return "BaseSortableModel[" + this._model + "]";
    }

    public void sort() {
        Comparator comparator = this.getComparator();
        if (null == comparator) {
            this._sortedIndicesList = null;
            this._baseIndicesList = null;
            return;
        }
        int sz = this.getRowCount();
        if (this._baseIndicesList == null || this._baseIndicesList.size() != sz) {
            this._baseIndicesList = new IntList(sz);
        }
        int rowIndex = this._model.getRowIndex();
        this._model.setRowIndex(0);
        if (this._model.isRowAvailable()) {
            Collections.sort(this._baseIndicesList, new RowDataComparator(comparator, this._model));
            this._sortedIndicesList = null;
        }
        this._model.setRowIndex(rowIndex);
    }

    private int _toSortedIndex(int baseIndex) {
        if (this._sortedIndicesList == null && this._baseIndicesList != null) {
            this._sortedIndicesList = (IntList)this._baseIndicesList.clone();
            for (int i = 0; i < this._baseIndicesList.size(); ++i) {
                Integer base = (Integer)this._baseIndicesList.get(i);
                this._sortedIndicesList.set(base, new Integer(i));
            }
        }
        return this._convertIndex(baseIndex, this._sortedIndicesList);
    }

    private int _toBaseIndex(int sortedIndex) {
        return this._convertIndex(sortedIndex, this._baseIndicesList);
    }

    private int _convertIndex(int index, List indices) {
        if (index < 0) {
            return index;
        }
        if (indices != null && indices.size() > index) {
            index = (Integer)indices.get(index);
        }
        return index;
    }

    protected static class RowDataComparator
    implements Comparator {
        private Comparator dataComparator = null;
        private DataModel dataModel = null;

        public RowDataComparator(Comparator comparator, DataModel model) {
            this.dataComparator = comparator;
            this.dataModel = model;
        }

        public int compare(Object arg1, Object arg2) {
            Integer r1 = (Integer)arg1;
            Integer r2 = (Integer)arg2;
            this.dataModel.setRowIndex(r1.intValue());
            Object rowData1 = this.dataModel.getRowData();
            this.dataModel.setRowIndex(r2.intValue());
            Object rowData2 = this.dataModel.getRowData();
            return this.dataComparator.compare(rowData1, rowData2);
        }
    }

    private static final class IntList
    extends ArrayList
    implements Cloneable {
        public IntList(int size) {
            super(size);
            this._expandToSize(size);
        }

        private void _expandToSize(int desiredSize) {
            for (int i = 0; i < desiredSize; ++i) {
                this.add(new Integer(i));
            }
        }
    }
}

