/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.myfaces.custom.swapimage;

import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import org.apache.myfaces.component.AttachedDeltaWrapper;
import javax.faces.component.UIComponent;


// Generated from class org.apache.myfaces.custom.swapimage.AbstractHtmlSwapImage.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlSwapImage extends org.apache.myfaces.custom.swapimage.AbstractHtmlSwapImage
{

    static public final String COMPONENT_FAMILY =
        "javax.faces.Graphic";
    static public final String COMPONENT_TYPE =
        "org.apache.myfaces.HtmlSwapImage";
    static public final String DEFAULT_RENDERER_TYPE = 
        "org.apache.myfaces.SwapImage";


    public HtmlSwapImage()
    {
        setRendererType("org.apache.myfaces.SwapImage");
    }

    public String getFamily()
    {
        return COMPONENT_FAMILY;
    }


    static private final java.util.Collection<String> CLIENT_EVENTS_LIST = 
        java.util.Collections.unmodifiableCollection(
            java.util.Arrays.asList(
             "click"
            , "dblclick"
            , "keydown"
            , "keypress"
            , "keyup"
            , "mousedown"
            , "mousemove"
            , "mouseout"
            , "mouseover"
            , "mouseup"
        ));

    public java.util.Collection<String> getEventNames()
    {
        return CLIENT_EVENTS_LIST;
    }

    
    // Property: border
    public String getBorder()
    {
        return (String) getStateHelper().eval(PropertyKeys.border, "Integer.MIN_VALUE");
    }
    
    public void setBorder(String border)
    {
        getStateHelper().put(PropertyKeys.border, border ); 
    }    
    // Property: hspace
    public String getHspace()
    {
        return (String) getStateHelper().eval(PropertyKeys.hspace);
    }
    
    public void setHspace(String hspace)
    {
        getStateHelper().put(PropertyKeys.hspace, hspace ); 
    }    
    // Property: vspace
    public String getVspace()
    {
        return (String) getStateHelper().eval(PropertyKeys.vspace);
    }
    
    public void setVspace(String vspace)
    {
        getStateHelper().put(PropertyKeys.vspace, vspace ); 
    }    
    // Property: swapImageUrl
    public String getSwapImageUrl()
    {
        return (String) getStateHelper().eval(PropertyKeys.swapImageUrl);
    }
    
    public void setSwapImageUrl(String swapImageUrl)
    {
        getStateHelper().put(PropertyKeys.swapImageUrl, swapImageUrl ); 
    }    
    // Property: activeImageUrl
    public String getActiveImageUrl()
    {
        return (String) getStateHelper().eval(PropertyKeys.activeImageUrl);
    }
    
    public void setActiveImageUrl(String activeImageUrl)
    {
        getStateHelper().put(PropertyKeys.activeImageUrl, activeImageUrl ); 
    }    
    // Property: alt
    public String getAlt()
    {
        return (String) getStateHelper().eval(PropertyKeys.alt);
    }
    
    public void setAlt(String alt)
    {
        getStateHelper().put(PropertyKeys.alt, alt ); 
    }    
    // Property: height
    public String getHeight()
    {
        return (String) getStateHelper().eval(PropertyKeys.height);
    }
    
    public void setHeight(String height)
    {
        getStateHelper().put(PropertyKeys.height, height ); 
    }    
    // Property: ismap
    public boolean isIsmap()
    {
        return (Boolean) getStateHelper().eval(PropertyKeys.ismap, false);
    }
    
    public void setIsmap(boolean ismap)
    {
        getStateHelper().put(PropertyKeys.ismap, ismap ); 
    }    
    // Property: longdesc
    public String getLongdesc()
    {
        return (String) getStateHelper().eval(PropertyKeys.longdesc);
    }
    
    public void setLongdesc(String longdesc)
    {
        getStateHelper().put(PropertyKeys.longdesc, longdesc ); 
    }    
    // Property: usemap
    public String getUsemap()
    {
        return (String) getStateHelper().eval(PropertyKeys.usemap);
    }
    
    public void setUsemap(String usemap)
    {
        getStateHelper().put(PropertyKeys.usemap, usemap ); 
    }    
    // Property: width
    public String getWidth()
    {
        return (String) getStateHelper().eval(PropertyKeys.width);
    }
    
    public void setWidth(String width)
    {
        getStateHelper().put(PropertyKeys.width, width ); 
    }    
    // Property: onclick
    public String getOnclick()
    {
        return (String) getStateHelper().eval(PropertyKeys.onclick);
    }
    
    public void setOnclick(String onclick)
    {
        getStateHelper().put(PropertyKeys.onclick, onclick ); 
    }    
    // Property: ondblclick
    public String getOndblclick()
    {
        return (String) getStateHelper().eval(PropertyKeys.ondblclick);
    }
    
    public void setOndblclick(String ondblclick)
    {
        getStateHelper().put(PropertyKeys.ondblclick, ondblclick ); 
    }    
    // Property: onkeydown
    public String getOnkeydown()
    {
        return (String) getStateHelper().eval(PropertyKeys.onkeydown);
    }
    
    public void setOnkeydown(String onkeydown)
    {
        getStateHelper().put(PropertyKeys.onkeydown, onkeydown ); 
    }    
    // Property: onkeypress
    public String getOnkeypress()
    {
        return (String) getStateHelper().eval(PropertyKeys.onkeypress);
    }
    
    public void setOnkeypress(String onkeypress)
    {
        getStateHelper().put(PropertyKeys.onkeypress, onkeypress ); 
    }    
    // Property: onkeyup
    public String getOnkeyup()
    {
        return (String) getStateHelper().eval(PropertyKeys.onkeyup);
    }
    
    public void setOnkeyup(String onkeyup)
    {
        getStateHelper().put(PropertyKeys.onkeyup, onkeyup ); 
    }    
    // Property: onmousedown
    public String getOnmousedown()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmousedown);
    }
    
    public void setOnmousedown(String onmousedown)
    {
        getStateHelper().put(PropertyKeys.onmousedown, onmousedown ); 
    }    
    // Property: onmousemove
    public String getOnmousemove()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmousemove);
    }
    
    public void setOnmousemove(String onmousemove)
    {
        getStateHelper().put(PropertyKeys.onmousemove, onmousemove ); 
    }    
    // Property: onmouseout
    public String getOnmouseout()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmouseout);
    }
    
    public void setOnmouseout(String onmouseout)
    {
        getStateHelper().put(PropertyKeys.onmouseout, onmouseout ); 
    }    
    // Property: onmouseover
    public String getOnmouseover()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmouseover);
    }
    
    public void setOnmouseover(String onmouseover)
    {
        getStateHelper().put(PropertyKeys.onmouseover, onmouseover ); 
    }    
    // Property: onmouseup
    public String getOnmouseup()
    {
        return (String) getStateHelper().eval(PropertyKeys.onmouseup);
    }
    
    public void setOnmouseup(String onmouseup)
    {
        getStateHelper().put(PropertyKeys.onmouseup, onmouseup ); 
    }    
    // Property: dir
    public String getDir()
    {
        return (String) getStateHelper().eval(PropertyKeys.dir);
    }
    
    public void setDir(String dir)
    {
        getStateHelper().put(PropertyKeys.dir, dir ); 
    }    
    // Property: lang
    public String getLang()
    {
        return (String) getStateHelper().eval(PropertyKeys.lang);
    }
    
    public void setLang(String lang)
    {
        getStateHelper().put(PropertyKeys.lang, lang ); 
    }    
    // Property: title
    public String getTitle()
    {
        return (String) getStateHelper().eval(PropertyKeys.title);
    }
    
    public void setTitle(String title)
    {
        getStateHelper().put(PropertyKeys.title, title ); 
    }    
    // Property: style
    public String getStyle()
    {
        return (String) getStateHelper().eval(PropertyKeys.style);
    }
    
    public void setStyle(String style)
    {
        getStateHelper().put(PropertyKeys.style, style ); 
    }    
    // Property: styleClass
    public String getStyleClass()
    {
        return (String) getStateHelper().eval(PropertyKeys.styleClass);
    }
    
    public void setStyleClass(String styleClass)
    {
        getStateHelper().put(PropertyKeys.styleClass, styleClass ); 
    }    
    // Property: align
    public String getAlign()
    {
        return (String) getStateHelper().eval(PropertyKeys.align);
    }
    
    public void setAlign(String align)
    {
        getStateHelper().put(PropertyKeys.align, align ); 
    }    

    protected enum PropertyKeys
    {
         border
        , hspace
        , vspace
        , swapImageUrl
        , activeImageUrl
        , alt
        , height
        , ismap
        , longdesc
        , usemap
        , width
        , onclick
        , ondblclick
        , onkeydown
        , onkeypress
        , onkeyup
        , onmousedown
        , onmousemove
        , onmouseout
        , onmouseover
        , onmouseup
        , dir
        , lang
        , title
        , style
        , styleClass
        , align
    }

 }
