/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.event.ObservesAsync;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProducerFactory;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;

public abstract class BaseProducerFactory<P>
implements ProducerFactory<P> {
    protected AnnotatedMethod<? super P> disposalMethod;
    protected Bean<P> parent;
    protected WebBeansContext webBeansContext;

    public BaseProducerFactory(Bean<P> parent, WebBeansContext webBeansContext) {
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        this.parent = parent;
        this.webBeansContext = webBeansContext;
    }

    protected <T> Set<InjectionPoint> getInjectionPoints(Bean<T> bean) {
        HashSet<InjectionPoint> disposalIPs = null;
        if (this.disposalMethod != null) {
            disposalIPs = new HashSet<InjectionPoint>(this.webBeansContext.getInjectionPointFactory().buildInjectionPoints(bean, this.disposalMethod));
        }
        return disposalIPs;
    }

    protected void defineDisposalMethod() {
        AnnotatedMember<P> producer = this.producerType();
        Set<Annotation> producerQualifiers = this.webBeansContext.getAnnotationManager().getQualifierAnnotations(producer.getAnnotations());
        if (producerQualifiers.size() == 1 && producerQualifiers.iterator().next().annotationType().equals(Default.class)) {
            producerQualifiers = Collections.emptySet();
        }
        HashSet<Annotation> producerQualifiersWithoutNamed = new HashSet<Annotation>();
        for (Annotation qualifier : producerQualifiers) {
            if (qualifier.annotationType().equals(Named.class)) continue;
            producerQualifiersWithoutNamed.add(qualifier);
        }
        AnnotatedType declaringType = producer.getDeclaringType();
        Type producerBaseType = this.producerType().getBaseType();
        Set annotatedMethods = this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(declaringType);
        AnnotatedMethod anyDisposal = null;
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            if (!annotatedMethod.getDeclaringType().equals(declaringType)) continue;
            for (AnnotatedParameter annotatedParameter : annotatedMethod.getParameters()) {
                if (!annotatedParameter.isAnnotationPresent(Disposes.class) || !GenericsUtil.satisfiesDependency(false, true, producerBaseType, annotatedParameter.getBaseType())) continue;
                Set<Annotation> producerQualifiersToCompare = producerQualifiers;
                Set<Annotation> disposalQualifiers = this.webBeansContext.getAnnotationManager().getQualifierAnnotations(annotatedParameter.getAnnotations());
                if (disposalQualifiers.size() == 1 && disposalQualifiers.iterator().next().annotationType().equals(Default.class)) {
                    disposalQualifiers = Collections.emptySet();
                }
                if (disposalQualifiers.size() == producerQualifiersToCompare.size() - 1) {
                    producerQualifiersToCompare = producerQualifiersWithoutNamed;
                }
                if (disposalQualifiers.size() != producerQualifiersToCompare.size()) continue;
                boolean same = true;
                for (Annotation disposalQualifier : disposalQualifiers) {
                    boolean found = false;
                    for (Annotation producerQualifier : producerQualifiers) {
                        if (!AnnotationUtil.isCdiAnnotationEqual(producerQualifier, disposalQualifier)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    same = false;
                    break;
                }
                if (!same) {
                    if (disposalQualifiers.size() != 1 || !AnyLiteral.INSTANCE.equals(disposalQualifiers.iterator().next())) continue;
                    anyDisposal = annotatedMethod;
                    continue;
                }
                if (this.disposalMethod != null) {
                    throw new WebBeansConfigurationException("There are multiple disposal method for the producer method : " + this.disposalMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getDeclaringType().getJavaClass());
                }
                this.validateDisposalMethod(declaringType, annotatedMethod);
                this.disposalMethod = annotatedMethod;
            }
        }
        if (this.disposalMethod == null && anyDisposal != null) {
            this.validateDisposalMethod(declaringType, anyDisposal);
            this.disposalMethod = anyDisposal;
        }
    }

    private void validateDisposalMethod(AnnotatedType declaringType, AnnotatedMethod<? super P> annotatedMethod) {
        if (!annotatedMethod.getDeclaringType().equals(declaringType)) {
            throw new WebBeansConfigurationException("Producer method component of the disposal method : " + annotatedMethod.getJavaMember().getName() + " in class : " + annotatedMethod.getDeclaringType().getJavaClass() + " must be in the same class!");
        }
        this.checkDisposalMethod(annotatedMethod);
    }

    protected abstract AnnotatedMember<? super P> producerType();

    private void checkDisposalMethod(AnnotatedMethod<? super P> annotatedMethod) {
        boolean found = false;
        for (AnnotatedParameter parameter : annotatedMethod.getParameters()) {
            if (!parameter.isAnnotationPresent(Disposes.class)) continue;
            if (found) {
                throw new WebBeansConfigurationException("Error in definining disposal method of annotated method : " + annotatedMethod + ". Multiple disposes annotation.");
            }
            found = true;
        }
        if (annotatedMethod.isAnnotationPresent(Inject.class) || AnnotationUtil.hasAnnotatedMethodParameterAnnotation(annotatedMethod, Observes.class) || AnnotationUtil.hasAnnotatedMethodParameterAnnotation(annotatedMethod, ObservesAsync.class) || annotatedMethod.isAnnotationPresent(Produces.class)) {
            throw new WebBeansConfigurationException("Error in definining disposal method of annotated method : " + annotatedMethod + ". Disposal methods  can not be annotated with @Initializer/@Destructor/@Produces annotation or has a parameter annotated with @Observes.");
        }
        for (AnnotatedParameter param : annotatedMethod.getParameters()) {
            Type type = param.getBaseType();
            if (type.equals(InjectionPoint.class)) {
                throw new WebBeansConfigurationException("Error in definining disposal method of annotated method : " + annotatedMethod + ". Disposal methods must not have an InjectionPoint.");
            }
            if (!Bean.class.isAssignableFrom(ClassUtil.getClass(type))) continue;
            throw new WebBeansConfigurationException("Error in defining disposal method of annoted method: " + annotatedMethod + ". Disposal methods must not have a Bean parameter.");
        }
    }
}

