/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.jackson;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.reactive.client.jackson.ClassConf;
import org.apache.pulsar.reactive.client.jackson.DeadLetterPolicyConf;
import org.apache.pulsar.reactive.client.jackson.RangeConf;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

abstract class ConverterUtils {
    ConverterUtils() {
    }

    static DeadLetterPolicy toDeadLetterPolicy(DeadLetterPolicyConf deadLetterPolicy) {
        if (deadLetterPolicy == null) {
            return null;
        }
        return DeadLetterPolicy.builder().maxRedeliverCount(deadLetterPolicy.getMaxRedeliverCount()).deadLetterTopic(deadLetterPolicy.getDeadLetterTopic()).retryLetterTopic(deadLetterPolicy.getRetryLetterTopic()).initialSubscriptionName(deadLetterPolicy.getInitialSubscriptionName()).build();
    }

    static <T> T toClass(ClassConf conf) {
        Class<?> klass;
        if (conf == null) {
            return null;
        }
        try {
            klass = ConverterUtils.loadClass(conf.getClassName(), Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(String.format("Failed to load class %s", conf.getClassName()));
        }
        try {
            if (conf.getArgs() != null) {
                Constructor<?> ctor = klass.getConstructor(Map.class);
                return (T)ctor.newInstance(conf.getArgs());
            }
            Constructor<?> ctor = klass.getConstructor(new Class[0]);
            return (T)ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(String.format("Class %s does not have a no-arg constructor or a constructor that accepts map", klass.getName()), ex);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new RuntimeException(String.format("Failed to create instance for %s", klass.getName()), ex);
        }
    }

    static KeySharedPolicy toKeySharedPolicy(String keySharedPolicy) {
        if (keySharedPolicy == null) {
            return null;
        }
        switch (keySharedPolicy) {
            case "AUTO_SPLIT": {
                return KeySharedPolicy.autoSplitHashRange();
            }
            case "STICKY": {
                return KeySharedPolicy.stickyHashRange();
            }
        }
        throw new IllegalArgumentException("Unsupported keySharedPolicy: " + keySharedPolicy);
    }

    static Scheduler toScheduler(String scheduler) {
        if (scheduler == null) {
            return null;
        }
        switch (scheduler) {
            case "parallel": {
                return Schedulers.parallel();
            }
            case "single": {
                return Schedulers.single();
            }
            case "boundedElastic": 
            case "elastic": {
                return Schedulers.boundedElastic();
            }
            case "immediate": {
                return Schedulers.immediate();
            }
        }
        throw new IllegalArgumentException("Unsupported scheduler: " + scheduler);
    }

    static Range toRange(RangeConf rangeConf) {
        if (rangeConf == null) {
            return null;
        }
        return new Range(rangeConf.getStart(), rangeConf.getEnd());
    }

    static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> objectClass;
        try {
            objectClass = Class.forName(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            if (classLoader != null) {
                objectClass = classLoader.loadClass(className);
            }
            throw ex;
        }
        return objectClass;
    }
}

