/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.reactive.client.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.DurationSerializer;
import java.io.IOException;
import java.time.Duration;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.KeySharedPolicy;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.reactive.client.api.ImmutableReactiveMessageConsumerSpec;
import org.apache.pulsar.reactive.client.api.ImmutableReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.ImmutableReactiveMessageSenderSpec;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageConsumerSpec;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageSenderSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumerSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderSpec;
import org.apache.pulsar.reactive.client.jackson.ClassConf;
import org.apache.pulsar.reactive.client.jackson.ConverterUtils;
import org.apache.pulsar.reactive.client.jackson.DeadLetterPolicyConf;
import org.apache.pulsar.reactive.client.jackson.ImmutableReactiveMessageConsumerSpecMixin;
import org.apache.pulsar.reactive.client.jackson.ImmutableReactiveMessageReaderSpecMixin;
import org.apache.pulsar.reactive.client.jackson.ImmutableReactiveMessageSenderSpecMixin;
import org.apache.pulsar.reactive.client.jackson.MutableReactiveMessageConsumerSpecMixin;
import org.apache.pulsar.reactive.client.jackson.MutableReactiveMessageReaderSpecMixin;
import org.apache.pulsar.reactive.client.jackson.MutableReactiveMessageSenderSpecMixin;
import org.apache.pulsar.reactive.client.jackson.RangeConf;
import reactor.core.scheduler.Scheduler;

public class PulsarReactiveClientModule
extends SimpleModule {
    public PulsarReactiveClientModule() {
        this.addDeserializer(KeySharedPolicy.class, new KeySharedPolicyDeserializer());
        this.addSerializer(KeySharedPolicy.class, new KeySharedPolicySerializer());
        this.addDeserializer(Scheduler.class, new SchedulerDeserializer());
        this.addSerializer(Scheduler.class, new SchedulerSerializer());
        this.addDeserializer(DeadLetterPolicy.class, new DeadLetterPolicyDeserializer());
        this.addDeserializer(CryptoKeyReader.class, new ClassDeserializer());
        this.addSerializer(CryptoKeyReader.class, new ClassSerializer());
        this.addDeserializer(Range.class, new RangeDeserializer());
        this.addDeserializer(MessageRouter.class, new ClassDeserializer());
        this.addSerializer(MessageRouter.class, new ClassSerializer());
        this.addDeserializer(BatcherBuilder.class, new ClassDeserializer());
        this.addDeserializer(Duration.class, (JsonDeserializer)DurationDeserializer.INSTANCE);
        this.addSerializer(Duration.class, (JsonSerializer)DurationSerializer.INSTANCE);
        this.setMixInAnnotation(ReactiveMessageConsumerSpec.class, ImmutableReactiveMessageConsumerSpecMixin.class);
        this.setMixInAnnotation(ImmutableReactiveMessageConsumerSpec.class, ImmutableReactiveMessageConsumerSpecMixin.class);
        this.setMixInAnnotation(MutableReactiveMessageConsumerSpec.class, MutableReactiveMessageConsumerSpecMixin.class);
        this.setMixInAnnotation(ReactiveMessageReaderSpec.class, ImmutableReactiveMessageReaderSpecMixin.class);
        this.setMixInAnnotation(ImmutableReactiveMessageReaderSpec.class, ImmutableReactiveMessageReaderSpecMixin.class);
        this.setMixInAnnotation(MutableReactiveMessageReaderSpec.class, MutableReactiveMessageReaderSpecMixin.class);
        this.setMixInAnnotation(ReactiveMessageSenderSpec.class, ImmutableReactiveMessageSenderSpecMixin.class);
        this.setMixInAnnotation(ImmutableReactiveMessageSenderSpec.class, ImmutableReactiveMessageSenderSpecMixin.class);
        this.setMixInAnnotation(MutableReactiveMessageSenderSpec.class, MutableReactiveMessageSenderSpecMixin.class);
    }

    public static class KeySharedPolicyDeserializer
    extends JsonDeserializer<KeySharedPolicy> {
        public KeySharedPolicy deserialize(JsonParser p, DeserializationContext context) throws IOException {
            return ConverterUtils.toKeySharedPolicy(p.getValueAsString());
        }
    }

    public static class KeySharedPolicySerializer
    extends JsonSerializer<KeySharedPolicy> {
        public void serialize(KeySharedPolicy keySharedPolicy, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (keySharedPolicy instanceof KeySharedPolicy.KeySharedPolicySticky) {
                gen.writeString("STICKY");
            } else if (keySharedPolicy instanceof KeySharedPolicy.KeySharedPolicyAutoSplit) {
                gen.writeString("AUTO_SPLIT");
            } else {
                gen.writeString(keySharedPolicy.getClass().getName());
            }
        }
    }

    public static class SchedulerDeserializer
    extends JsonDeserializer<Scheduler> {
        public Scheduler deserialize(JsonParser p, DeserializationContext context) throws IOException {
            return ConverterUtils.toScheduler(p.getValueAsString());
        }
    }

    public static class SchedulerSerializer
    extends JsonSerializer<Scheduler> {
        public void serialize(Scheduler scheduler, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            switch (scheduler.getClass().getName()) {
                case "reactor.core.scheduler.BoundedElasticScheduler": {
                    gen.writeString("boundedElastic");
                    break;
                }
                case "reactor.core.scheduler.ParallelScheduler": {
                    gen.writeString("parallel");
                    break;
                }
                case "reactor.core.scheduler.SingleScheduler": {
                    gen.writeString("single");
                    break;
                }
                case "reactor.core.scheduler.ImmediateScheduler": {
                    gen.writeString("immediate");
                    break;
                }
                case "reactor.core.scheduler.Schedulers$CachedScheduler": {
                    gen.writeString(scheduler.toString().substring("Schedulers.".length(), scheduler.toString().length() - "()".length()));
                    break;
                }
                default: {
                    gen.writeString(scheduler.getClass().getName());
                }
            }
        }
    }

    public static class DeadLetterPolicyDeserializer
    extends JsonDeserializer<DeadLetterPolicy> {
        public DeadLetterPolicy deserialize(JsonParser p, DeserializationContext context) throws IOException {
            DeadLetterPolicyConf deadLetterPolicyConf = (DeadLetterPolicyConf)p.readValueAs(DeadLetterPolicyConf.class);
            return ConverterUtils.toDeadLetterPolicy(deadLetterPolicyConf);
        }
    }

    public static class ClassDeserializer<T>
    extends JsonDeserializer<T> {
        public T deserialize(JsonParser p, DeserializationContext context) throws IOException {
            ClassConf classConf = (ClassConf)p.readValueAs(ClassConf.class);
            return ConverterUtils.toClass(classConf);
        }
    }

    public static class ClassSerializer<T>
    extends JsonSerializer<T> {
        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField("className", value.getClass().getName());
            gen.writeEndObject();
        }
    }

    public static class RangeDeserializer
    extends JsonDeserializer<Range> {
        public Range deserialize(JsonParser p, DeserializationContext context) throws IOException {
            RangeConf rangeConf = (RangeConf)p.readValueAs(RangeConf.class);
            return ConverterUtils.toRange(rangeConf);
        }
    }
}

