/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Classes {
    private static final Map<Class<?>, Class<?>> primitiveWrappers = new HashMap();
    private static final HashMap<String, Class> primitives = new HashMap();

    public static Class forName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        int arrayDimentions = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++arrayDimentions;
        }
        Class<?> clazz = primitives.get(string);
        if (clazz == null) {
            clazz = Class.forName(string, true, classLoader);
        }
        if (arrayDimentions == 0) {
            return clazz;
        }
        return Array.newInstance(clazz, new int[arrayDimentions]).getClass();
    }

    public static String packageName(Class clazz) {
        return Classes.packageName(clazz.getName());
    }

    public static String packageName(String clazzName) {
        int i = clazzName.lastIndexOf(46);
        if (i > 0) {
            return clazzName.substring(0, i);
        }
        return "";
    }

    public static List<String> getSimpleNames(Class ... classes) {
        ArrayList<String> list = new ArrayList<String>();
        for (Class aClass : classes) {
            list.add(aClass.getSimpleName());
        }
        return list;
    }

    public static Class<?> deprimitivize(Class<?> fieldType) {
        fieldType = fieldType.isPrimitive() ? primitiveWrappers.get(fieldType) : fieldType;
        return fieldType;
    }

    public static List<Class<?>> ancestors(Class clazz) {
        ArrayList ancestors = new ArrayList();
        while (clazz != null && !clazz.equals(Object.class)) {
            ancestors.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return ancestors;
    }

    static {
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitiveWrappers.put(Boolean.TYPE, Boolean.class);
        primitiveWrappers.put(Byte.TYPE, Byte.class);
        primitiveWrappers.put(Character.TYPE, Character.class);
        primitiveWrappers.put(Double.TYPE, Double.class);
        primitiveWrappers.put(Float.TYPE, Float.class);
        primitiveWrappers.put(Integer.TYPE, Integer.class);
        primitiveWrappers.put(Long.TYPE, Long.class);
        primitiveWrappers.put(Short.TYPE, Short.class);
    }
}

