/*
 * Decompiled with CFR 0.152.
 */
package openejb.shade.org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import openejb.shade.org.apache.bcel.Constants;
import openejb.shade.org.apache.bcel.classfile.Constant;
import openejb.shade.org.apache.bcel.classfile.ConstantClass;
import openejb.shade.org.apache.bcel.classfile.ConstantPool;
import openejb.shade.org.apache.bcel.generic.ClassGenException;
import openejb.shade.org.apache.bcel.generic.ConstantPoolGen;
import openejb.shade.org.apache.bcel.generic.IndexedInstruction;
import openejb.shade.org.apache.bcel.generic.Instruction;
import openejb.shade.org.apache.bcel.generic.Type;
import openejb.shade.org.apache.bcel.generic.TypedInstruction;
import openejb.shade.org.apache.bcel.util.ByteSequence;

public abstract class CPInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    protected int index;

    CPInstruction() {
    }

    protected CPInstruction(short opcode, int index) {
        super(opcode, (short)3);
        this.setIndex(index);
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeShort(this.index);
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + this.index;
    }

    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        String str = cp.constantToString(c);
        if (c instanceof ConstantClass) {
            str = str.replace('.', '/');
        }
        return Constants.OPCODE_NAMES[this.opcode] + " " + str;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.setIndex(bytes.readUnsignedShort());
        this.length = (short)3;
    }

    public final int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (index < 0) {
            throw new ClassGenException("Negative index value: " + index);
        }
        this.index = index;
    }

    public Type getType(ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        String name = cp.getConstantString(this.index, (byte)7);
        if (!name.startsWith("[")) {
            name = "L" + name + ";";
        }
        return Type.getType(name);
    }
}

