/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ValueDescriptor;

abstract class ObjectWriter
extends ObjectOutputStream {
    protected final Serializable object;
    private ValueDescriptor _desc;
    private PutFieldImpl _putFields;
    private WriteObjectState state = NOT_IN_WRITE_OBJECT;
    private byte streamFormatVersion = 1;
    static WriteObjectState NOT_IN_WRITE_OBJECT = new WriteObjectState(){

        void beforeWriteObject(ObjectWriter writer) throws IOException {
            writer.state = IN_WRITE_OBJECT;
        }

        void afterWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }

        void beforeDefaultWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }

        void afterDefaultWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }
    };
    static WriteObjectState IN_WRITE_OBJECT = new WriteObjectState(){

        void beforeWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("already in writeObject");
        }

        void afterWriteObject(ObjectWriter writer) throws IOException {
            writer.state = NOT_IN_WRITE_OBJECT;
            writer.writeBoolean(false);
            if (writer.getStreamFormatVersion() == 2) {
                writer._nullValue();
            }
        }

        void beforeDefaultWriteObject(ObjectWriter writer) throws IOException {
            writer.state = IN_DEFAULT_WRITE_OBJECT;
            writer.writeBoolean(true);
        }

        void afterDefaultWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }

        void beforeWriteData(ObjectWriter writer) throws IOException {
            writer.state = WROTE_CUSTOM_DATA;
            writer.writeBoolean(false);
            if (writer.getStreamFormatVersion() == 2) {
                writer._startValue(writer._desc.getRepositoryID());
            }
        }
    };
    static WriteObjectState IN_DEFAULT_WRITE_OBJECT = new WriteObjectState(){

        void beforeWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }

        void afterWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }

        void beforeDefaultWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }

        void afterDefaultWriteObject(ObjectWriter writer) throws IOException {
            writer.state = WROTE_DEFAULT_DATA;
        }

        void beforeWriteData(ObjectWriter writer) throws IOException {
        }
    };
    static WriteObjectState WROTE_DEFAULT_DATA = new WriteObjectState(){

        void afterWriteObject(ObjectWriter writer) throws IOException {
            writer.state = NOT_IN_WRITE_OBJECT;
            if (writer.getStreamFormatVersion() == 2) {
                writer._nullValue();
            }
        }

        void beforeDefaultWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }

        void afterDefaultWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }

        void beforeWriteData(ObjectWriter writer) throws IOException {
            writer.state = WROTE_CUSTOM_DATA;
            if (writer.getStreamFormatVersion() == 2) {
                writer._startValue(writer._desc.getRepositoryID());
            }
        }
    };
    static WriteObjectState WROTE_CUSTOM_DATA = new WriteObjectState(){

        void afterWriteObject(ObjectWriter writer) throws IOException {
            if (writer.getStreamFormatVersion() == 2) {
                writer._endValue();
            }
            writer.state = NOT_IN_WRITE_OBJECT;
        }

        void beforeDefaultWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException("");
        }

        void afterDefaultWriteObject(ObjectWriter writer) {
            throw new IllegalStateException("");
        }

        void beforeWriteData(ObjectWriter writer) throws IOException {
        }
    };

    protected void beforeWriteData() throws IOException {
        this.state.beforeWriteData(this);
    }

    ObjectWriter(Serializable obj) throws IOException {
        this.object = obj;
    }

    protected byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    abstract ObjectReader getObjectReader(Object var1);

    void setCurrentValueDescriptor(ValueDescriptor desc) {
        this._desc = desc;
        this._putFields = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void defaultWriteObject() throws IOException, NotActiveException {
        if (this._desc == null) {
            throw new NotActiveException();
        }
        this.state.beforeDefaultWriteObject(this);
        try {
            this._desc.defaultWriteValue(this, this.object);
        }
        finally {
            this.state.afterDefaultWriteObject(this);
        }
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this._desc == null) {
            throw new NotActiveException();
        }
        this._putFields = new PutFieldImpl(this._desc);
        return this._putFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFields() throws IOException {
        if (this._putFields == null) {
            throw new NotActiveException("no current PutFields");
        }
        if (this._putFields.slice != this._desc) {
            throw new NotActiveException("PutField cannot survive writeObject invocation");
        }
        this.state.beforeDefaultWriteObject(this);
        try {
            this._putFields.write(this);
        }
        finally {
            this.state.afterDefaultWriteObject(this);
        }
    }

    public void close() {
    }

    public void flush() {
    }

    public abstract void writeValueObject(Object var1) throws IOException;

    public abstract void writeRemoteObject(Object var1) throws IOException;

    public abstract void writeCorbaObject(Object var1) throws IOException;

    public abstract void writeAny(Object var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeWriteObject(ValueDescriptor descriptor, Serializable val, Method _write_object_method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        ValueDescriptor desc = this._desc;
        WriteObjectState old_state = this.state;
        this.state = NOT_IN_WRITE_OBJECT;
        try {
            this.setCurrentValueDescriptor(descriptor);
            this.writeByte(this.getStreamFormatVersion());
            this.state.beforeWriteObject(this);
            _write_object_method.invoke((Object)val, this);
            this.state.afterWriteObject(this);
        }
        finally {
            this.state = old_state;
            this.setCurrentValueDescriptor(desc);
        }
    }

    protected abstract void _startValue(String var1) throws IOException;

    protected abstract void _endValue() throws IOException;

    protected abstract void _nullValue() throws IOException;

    void invokeWriteExternal(Externalizable externalizable) throws IOException {
        this.writeByte(this.getStreamFormatVersion());
        externalizable.writeExternal(this);
    }

    static class PutFieldImpl
    extends ObjectOutputStream.PutField {
        ValueDescriptor slice;
        Map valueMap = new HashMap();

        PutFieldImpl(ValueDescriptor slice) {
            this.slice = slice;
        }

        public void put(String name, boolean val) {
            this.valueMap.put(name, new Boolean(val));
        }

        public void put(String name, byte val) {
            this.valueMap.put(name, new Byte(val));
        }

        public void put(String name, char val) {
            this.valueMap.put(name, new Character(val));
        }

        public void put(String name, double val) {
            this.valueMap.put(name, new Double(val));
        }

        public void put(String name, float val) {
            this.valueMap.put(name, new Float(val));
        }

        public void put(String name, int val) {
            this.valueMap.put(name, new Integer(val));
        }

        public void put(String name, long val) {
            this.valueMap.put(name, new Long(val));
        }

        public void put(String name, Object val) {
            this.valueMap.put(name, val);
        }

        public void put(String name, short val) {
            this.valueMap.put(name, new Short(val));
        }

        public void write(ObjectOutput out) throws IOException {
            this.slice.writeFields((ObjectWriter)out, this.valueMap);
        }
    }

    static class WriteObjectState {
        WriteObjectState() {
        }

        void beforeWriteObject(ObjectWriter writer) throws IOException {
        }

        void afterWriteObject(ObjectWriter writer) throws IOException {
        }

        void beforeDefaultWriteObject(ObjectWriter writer) throws IOException {
        }

        void afterDefaultWriteObject(ObjectWriter writer) throws IOException {
        }

        void beforeWriteData(ObjectWriter writer) throws IOException {
        }
    }
}

