/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.openejb.jee.jba.cmp;

import javax.xml.bind.annotation.XmlRegistry;


/**
 * This object contains factory methods for each
 * Java content interface and Java element interface
 * generated in the org.apache.openejb.jee.jba.cmp package.
 * <p>An ObjectFactory allows you to programatically
 * construct new instances of the Java representation
 * for XML content. The Java representation of XML
 * content can consist of schema derived interfaces
 * and classes representing the binding of schema
 * type definitions, element declarations and model
 * groups.  Factory methods for each of these are
 * provided in this class.
 */
@XmlRegistry
public class ObjectFactory {


    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.apache.openejb.jee.jba.cmp
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link DropColumnTemplate }
     */
    public DropColumnTemplate createDropColumnTemplate() {
        return new DropColumnTemplate();
    }

    /**
     * Create an instance of {@link Mapper }
     */
    public Mapper createMapper() {
        return new Mapper();
    }

    /**
     * Create an instance of {@link TrueMapping }
     */
    public TrueMapping createTrueMapping() {
        return new TrueMapping();
    }

    /**
     * Create an instance of {@link ReservedWords }
     */
    public ReservedWords createReservedWords() {
        return new ReservedWords();
    }

    /**
     * Create an instance of {@link Relationships }
     */
    public Relationships createRelationships() {
        return new Relationships();
    }

    /**
     * Create an instance of {@link TimestampColumn }
     */
    public TimestampColumn createTimestampColumn() {
        return new TimestampColumn();
    }

    /**
     * Create an instance of {@link FunctionName }
     */
    public FunctionName createFunctionName() {
        return new FunctionName();
    }

    /**
     * Create an instance of {@link Strategy }
     */
    public Strategy createStrategy() {
        return new Strategy();
    }

    /**
     * Create an instance of {@link Description }
     */
    public Description createDescription() {
        return new Description();
    }

    /**
     * Create an instance of {@link AliasMaxLength }
     */
    public AliasMaxLength createAliasMaxLength() {
        return new AliasMaxLength();
    }

    /**
     * Create an instance of {@link JavaType }
     */
    public JavaType createJavaType() {
        return new JavaType();
    }

    /**
     * Create an instance of {@link DatasourceMapping }
     */
    public DatasourceMapping createDatasourceMapping() {
        return new DatasourceMapping();
    }

    /**
     * Create an instance of {@link FetchSize }
     */
    public FetchSize createFetchSize() {
        return new FetchSize();
    }

    /**
     * Create an instance of {@link EntityCommands }
     */
    public EntityCommands createEntityCommands() {
        return new EntityCommands();
    }

    /**
     * Create an instance of {@link DynamicQl }
     */
    public DynamicQl createDynamicQl() {
        return new DynamicQl();
    }

    /**
     * Create an instance of {@link FieldType }
     */
    public FieldType createFieldType() {
        return new FieldType();
    }

    /**
     * Create an instance of {@link FkConstraintTemplate }
     */
    public FkConstraintTemplate createFkConstraintTemplate() {
        return new FkConstraintTemplate();
    }

    /**
     * Create an instance of {@link Select }
     */
    public Select createSelect() {
        return new Select();
    }

    /**
     * Create an instance of {@link Entity }
     */
    public Entity createEntity() {
        return new Entity();
    }

    /**
     * Create an instance of {@link LazyLoadGroups }
     */
    public LazyLoadGroups createLazyLoadGroups() {
        return new LazyLoadGroups();
    }

    /**
     * Create an instance of {@link EnterpriseBeans }
     */
    public EnterpriseBeans createEnterpriseBeans() {
        return new EnterpriseBeans();
    }

    /**
     * Create an instance of {@link ReadTimeOut }
     */
    public ReadTimeOut createReadTimeOut() {
        return new ReadTimeOut();
    }

    /**
     * Create an instance of {@link JdbcType }
     */
    public JdbcType createJdbcType() {
        return new JdbcType();
    }

    /**
     * Create an instance of {@link DependentValueClasses }
     */
    public DependentValueClasses createDependentValueClasses() {
        return new DependentValueClasses();
    }

    /**
     * Create an instance of {@link RelationTableMapping }
     */
    public RelationTableMapping createRelationTableMapping() {
        return new RelationTableMapping();
    }

    /**
     * Create an instance of {@link PageSize }
     */
    public PageSize createPageSize() {
        return new PageSize();
    }

    /**
     * Create an instance of {@link Audit }
     */
    public Audit createAudit() {
        return new Audit();
    }

    /**
     * Create an instance of {@link Distinct }
     */
    public Distinct createDistinct() {
        return new Distinct();
    }

    /**
     * Create an instance of {@link CreateTable }
     */
    public CreateTable createCreateTable() {
        return new CreateTable();
    }

    /**
     * Create an instance of {@link AlterColumnTemplate }
     */
    public AlterColumnTemplate createAlterColumnTemplate() {
        return new AlterColumnTemplate();
    }

    /**
     * Create an instance of {@link LoadGroupName }
     */
    public LoadGroupName createLoadGroupName() {
        return new LoadGroupName();
    }

    /**
     * Create an instance of {@link Defaults }
     */
    public Defaults createDefaults() {
        return new Defaults();
    }

    /**
     * Create an instance of {@link Mapping }
     */
    public Mapping createMapping() {
        return new Mapping();
    }

    /**
     * Create an instance of {@link LoadGroups }
     */
    public LoadGroups createLoadGroups() {
        return new LoadGroups();
    }

    /**
     * Create an instance of {@link NotNull }
     */
    public NotNull createNotNull() {
        return new NotNull();
    }

    /**
     * Create an instance of {@link EjbRelationName }
     */
    public EjbRelationName createEjbRelationName() {
        return new EjbRelationName();
    }

    /**
     * Create an instance of {@link Property }
     */
    public Property createProperty() {
        return new Property();
    }

    /**
     * Create an instance of {@link UnknownPkClass }
     */
    public UnknownPkClass createUnknownPkClass() {
        return new UnknownPkClass();
    }

    /**
     * Create an instance of {@link TypeMapping }
     */
    public TypeMapping createTypeMapping() {
        return new TypeMapping();
    }

    /**
     * Create an instance of {@link FalseMapping }
     */
    public FalseMapping createFalseMapping() {
        return new FalseMapping();
    }

    /**
     * Create an instance of {@link AdditionalColumns }
     */
    public AdditionalColumns createAdditionalColumns() {
        return new AdditionalColumns();
    }

    /**
     * Create an instance of {@link SqlType }
     */
    public SqlType createSqlType() {
        return new SqlType();
    }

    /**
     * Create an instance of {@link SubquerySupported }
     */
    public SubquerySupported createSubquerySupported() {
        return new SubquerySupported();
    }

    /**
     * Create an instance of {@link StateFactory }
     */
    public StateFactory createStateFactory() {
        return new StateFactory();
    }

    /**
     * Create an instance of {@link CreatedTime }
     */
    public CreatedTime createCreatedTime() {
        return new CreatedTime();
    }

    /**
     * Create an instance of {@link AliasHeaderSuffix }
     */
    public AliasHeaderSuffix createAliasHeaderSuffix() {
        return new AliasHeaderSuffix();
    }

    /**
     * Create an instance of {@link UpdatedBy }
     */
    public UpdatedBy createUpdatedBy() {
        return new UpdatedBy();
    }

    /**
     * Create an instance of {@link CleanReadAheadOnLoad }
     */
    public CleanReadAheadOnLoad createCleanReadAheadOnLoad() {
        return new CleanReadAheadOnLoad();
    }

    /**
     * Create an instance of {@link FunctionSql }
     */
    public FunctionSql createFunctionSql() {
        return new FunctionSql();
    }

    /**
     * Create an instance of {@link PropertyName }
     */
    public PropertyName createPropertyName() {
        return new PropertyName();
    }

    /**
     * Create an instance of {@link SqlStatement }
     */
    public SqlStatement createSqlStatement() {
        return new SqlStatement();
    }

    /**
     * Create an instance of {@link JbossQl }
     */
    public JbossQl createJbossQl() {
        return new JbossQl();
    }

    /**
     * Create an instance of {@link EagerLoadGroup }
     */
    public EagerLoadGroup createEagerLoadGroup() {
        return new EagerLoadGroup();
    }

    /**
     * Create an instance of {@link Datasource }
     */
    public Datasource createDatasource() {
        return new Datasource();
    }

    /**
     * Create an instance of {@link AutoIncrementTemplate }
     */
    public AutoIncrementTemplate createAutoIncrementTemplate() {
        return new AutoIncrementTemplate();
    }

    /**
     * Create an instance of {@link LazyResultsetLoading }
     */
    public LazyResultsetLoading createLazyResultsetLoading() {
        return new LazyResultsetLoading();
    }

    /**
     * Create an instance of {@link QlCompiler }
     */
    public QlCompiler createQlCompiler() {
        return new QlCompiler();
    }

    /**
     * Create an instance of {@link AliasHeaderPrefix }
     */
    public AliasHeaderPrefix createAliasHeaderPrefix() {
        return new AliasHeaderPrefix();
    }

    /**
     * Create an instance of {@link LeftJoin }
     */
    public LeftJoin createLeftJoin() {
        return new LeftJoin();
    }

    /**
     * Create an instance of {@link LoadGroup }
     */
    public LoadGroup createLoadGroup() {
        return new LoadGroup();
    }

    /**
     * Create an instance of {@link ResultReader }
     */
    public ResultReader createResultReader() {
        return new ResultReader();
    }

    /**
     * Create an instance of {@link KeyFields }
     */
    public KeyFields createKeyFields() {
        return new KeyFields();
    }

    /**
     * Create an instance of {@link UserTypeMapping }
     */
    public UserTypeMapping createUserTypeMapping() {
        return new UserTypeMapping();
    }

    /**
     * Create an instance of {@link TypeMappings }
     */
    public TypeMappings createTypeMappings() {
        return new TypeMappings();
    }

    /**
     * Create an instance of {@link ReadAhead }
     */
    public ReadAhead createReadAhead() {
        return new ReadAhead();
    }

    /**
     * Create an instance of {@link EntityCommand }
     */
    public EntityCommand createEntityCommand() {
        return new EntityCommand();
    }

    /**
     * Create an instance of {@link VersionColumn }
     */
    public VersionColumn createVersionColumn() {
        return new VersionColumn();
    }

    /**
     * Create an instance of {@link AutoIncrement }
     */
    public AutoIncrement createAutoIncrement() {
        return new AutoIncrement();
    }

    /**
     * Create an instance of {@link PkConstraint }
     */
    public PkConstraint createPkConstraint() {
        return new PkConstraint();
    }

    /**
     * Create an instance of {@link EjbRelation }
     */
    public EjbRelation createEjbRelation() {
        return new EjbRelation();
    }

    /**
     * Create an instance of {@link ReadStrategy }
     */
    public ReadStrategy createReadStrategy() {
        return new ReadStrategy();
    }

    /**
     * Create an instance of {@link Attribute }
     */
    public Attribute createAttribute() {
        return new Attribute();
    }

    /**
     * Create an instance of {@link EjbRelationshipRoleName }
     */
    public EjbRelationshipRoleName createEjbRelationshipRoleName() {
        return new EjbRelationshipRoleName();
    }

    /**
     * Create an instance of {@link UnknownPk }
     */
    public UnknownPk createUnknownPk() {
        return new UnknownPk();
    }

    /**
     * Create an instance of {@link Other }
     */
    public Other createOther() {
        return new Other();
    }

    /**
     * Create an instance of {@link ListCacheMax }
     */
    public ListCacheMax createListCacheMax() {
        return new ListCacheMax();
    }

    /**
     * Create an instance of {@link ReadOnly }
     */
    public ReadOnly createReadOnly() {
        return new ReadOnly();
    }

    /**
     * Create an instance of {@link JbosscmpJdbc }
     */
    public JbosscmpJdbc createJbosscmpJdbc() {
        return new JbosscmpJdbc();
    }

    /**
     * Create an instance of {@link QueryMethod }
     */
    public QueryMethod createQueryMethod() {
        return new QueryMethod();
    }

    /**
     * Create an instance of {@link AddColumnTemplate }
     */
    public AddColumnTemplate createAddColumnTemplate() {
        return new AddColumnTemplate();
    }

    /**
     * Create an instance of {@link Dbindex }
     */
    public Dbindex createDbindex() {
        return new Dbindex();
    }

    /**
     * Create an instance of {@link GroupName }
     */
    public GroupName createGroupName() {
        return new GroupName();
    }

    /**
     * Create an instance of {@link MethodName }
     */
    public MethodName createMethodName() {
        return new MethodName();
    }

    /**
     * Create an instance of {@link From }
     */
    public From createFrom() {
        return new From();
    }

    /**
     * Create an instance of {@link RowLocking }
     */
    public RowLocking createRowLocking() {
        return new RowLocking();
    }

    /**
     * Create an instance of {@link PkConstraintTemplate }
     */
    public PkConstraintTemplate createPkConstraintTemplate() {
        return new PkConstraintTemplate();
    }

    /**
     * Create an instance of {@link UpdatedTime }
     */
    public UpdatedTime createUpdatedTime() {
        return new UpdatedTime();
    }

    /**
     * Create an instance of {@link FunctionMapping }
     */
    public FunctionMapping createFunctionMapping() {
        return new FunctionMapping();
    }

    /**
     * Create an instance of {@link CreatedBy }
     */
    public CreatedBy createCreatedBy() {
        return new CreatedBy();
    }

    /**
     * Create an instance of {@link MappedType }
     */
    public MappedType createMappedType() {
        return new MappedType();
    }

    /**
     * Create an instance of {@link MethodParams }
     */
    public MethodParams createMethodParams() {
        return new MethodParams();
    }

    /**
     * Create an instance of {@link EjbRelationshipRole }
     */
    public EjbRelationshipRole createEjbRelationshipRole() {
        return new EjbRelationshipRole();
    }

    /**
     * Create an instance of {@link PreferredRelationMapping }
     */
    public PreferredRelationMapping createPreferredRelationMapping() {
        return new PreferredRelationMapping();
    }

    /**
     * Create an instance of {@link ForeignKeyMapping }
     */
    public ForeignKeyMapping createForeignKeyMapping() {
        return new ForeignKeyMapping();
    }

    /**
     * Create an instance of {@link FkConstraint }
     */
    public FkConstraint createFkConstraint() {
        return new FkConstraint();
    }

    /**
     * Create an instance of {@link PostTableCreate }
     */
    public PostTableCreate createPostTableCreate() {
        return new PostTableCreate();
    }

    /**
     * Create an instance of {@link EjbName }
     */
    public EjbName createEjbName() {
        return new EjbName();
    }

    /**
     * Create an instance of {@link AlterTable }
     */
    public AlterTable createAlterTable() {
        return new AlterTable();
    }

    /**
     * Create an instance of {@link OptimisticLocking }
     */
    public OptimisticLocking createOptimisticLocking() {
        return new OptimisticLocking();
    }

    /**
     * Create an instance of {@link CmpField }
     */
    public CmpField createCmpField() {
        return new CmpField();
    }

    /**
     * Create an instance of {@link ModifiedStrategy }
     */
    public ModifiedStrategy createModifiedStrategy() {
        return new ModifiedStrategy();
    }

    /**
     * Create an instance of {@link Alias }
     */
    public Alias createAlias() {
        return new Alias();
    }

    /**
     * Create an instance of {@link KeyField }
     */
    public KeyField createKeyField() {
        return new KeyField();
    }

    /**
     * Create an instance of {@link ColumnName }
     */
    public ColumnName createColumnName() {
        return new ColumnName();
    }

    /**
     * Create an instance of {@link Where }
     */
    public Where createWhere() {
        return new Where();
    }

    /**
     * Create an instance of {@link Name }
     */
    public Name createName() {
        return new Name();
    }

    /**
     * Create an instance of {@link KeyGeneratorFactory }
     */
    public KeyGeneratorFactory createKeyGeneratorFactory() {
        return new KeyGeneratorFactory();
    }

    /**
     * Create an instance of {@link MethodParam }
     */
    public MethodParam createMethodParam() {
        return new MethodParam();
    }

    /**
     * Create an instance of {@link CheckDirtyAfterGet }
     */
    public CheckDirtyAfterGet createCheckDirtyAfterGet() {
        return new CheckDirtyAfterGet();
    }

    /**
     * Create an instance of {@link TableName }
     */
    public TableName createTableName() {
        return new TableName();
    }

    /**
     * Create an instance of {@link FieldName }
     */
    public FieldName createFieldName() {
        return new FieldName();
    }

    /**
     * Create an instance of {@link RowLockingTemplate }
     */
    public RowLockingTemplate createRowLockingTemplate() {
        return new RowLockingTemplate();
    }

    /**
     * Create an instance of {@link Order }
     */
    public Order createOrder() {
        return new Order();
    }

    /**
     * Create an instance of {@link DependentValueClass }
     */
    public DependentValueClass createDependentValueClass() {
        return new DependentValueClass();
    }

    /**
     * Create an instance of {@link RemoveTable }
     */
    public RemoveTable createRemoveTable() {
        return new RemoveTable();
    }

    /**
     * Create an instance of {@link UserTypeMappings }
     */
    public UserTypeMappings createUserTypeMappings() {
        return new UserTypeMappings();
    }

    /**
     * Create an instance of {@link BatchCascadeDelete }
     */
    public BatchCascadeDelete createBatchCascadeDelete() {
        return new BatchCascadeDelete();
    }

    /**
     * Create an instance of {@link ThrowRuntimeExceptions }
     */
    public ThrowRuntimeExceptions createThrowRuntimeExceptions() {
        return new ThrowRuntimeExceptions();
    }

    /**
     * Create an instance of {@link Query }
     */
    public Query createQuery() {
        return new Query();
    }

    /**
     * Create an instance of {@link DeclaredSql }
     */
    public DeclaredSql createDeclaredSql() {
        return new DeclaredSql();
    }

    /**
     * Create an instance of {@link Word }
     */
    public Word createWord() {
        return new Word();
    }

    /**
     * Create an instance of {@link ParamSetter }
     */
    public ParamSetter createParamSetter() {
        return new ParamSetter();
    }

    /**
     * Create an instance of {@link Class }
     */
    public Class createClass() {
        return new Class();
    }

}
