/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.wink.common.internal.providers.entity.xml;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

/**
 * Specialized exception to understand when a DTD entity reference may have
 * occurred.
 */
public class EntityReferenceXMLStreamException extends XMLStreamException {

    private static final long serialVersionUID = 3591147568986621256L;

    public EntityReferenceXMLStreamException() {
        super();
    }

    public EntityReferenceXMLStreamException(String msg) {
        super(msg);
    }

    public EntityReferenceXMLStreamException(Throwable t) {
        super(t);
    }

    public EntityReferenceXMLStreamException(String msg, Location l) {
        super(msg, l);
    }

    public EntityReferenceXMLStreamException(String msg, Throwable t) {
        super(msg, t);
    }

    public EntityReferenceXMLStreamException(String msg, Location l, Throwable t) {
        super(msg, l, t);
    }
}
