/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.header;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControlHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<CacheControl> {
    private static final String S_MAXAGE = "s-maxage";
    private static final String MAX_AGE = "max-age";
    private static final String PROXY_REVALIDATE = "proxy-revalidate";
    private static final String MUST_REVALIDATE = "must-revalidate";
    private static final String NO_TRANSFORM = "no-transform";
    private static final String NO_STORE = "no-store";
    private static final String NO_CACHE = "no-cache";
    private static final String PRIVATE = "private";

    public CacheControl fromString(String value) throws IllegalArgumentException {
        throw new UnsupportedOperationException(Messages.getMessage("jaxrsCacheControlTypeSupport"));
    }

    public String toString(CacheControl header) {
        Set entrySet;
        if (header == null) {
            throw new IllegalArgumentException(Messages.getMessage("headerIsNull", "CacheControl"));
        }
        StringBuffer cacheControlHeader = new StringBuffer();
        if (header.isPrivate()) {
            this.appendDirectiveWithValues(cacheControlHeader, PRIVATE, this.generateDirectiveValuesList(header.getPrivateFields()));
        }
        if (header.isNoCache()) {
            this.appendDirectiveWithValues(cacheControlHeader, NO_CACHE, this.generateDirectiveValuesList(header.getNoCacheFields()));
        }
        if (header.isNoStore()) {
            this.appendDirective(cacheControlHeader, NO_STORE);
        }
        if (header.isNoTransform()) {
            this.appendDirective(cacheControlHeader, NO_TRANSFORM);
        }
        if (header.isMustRevalidate()) {
            this.appendDirective(cacheControlHeader, MUST_REVALIDATE);
        }
        if (header.isProxyRevalidate()) {
            this.appendDirective(cacheControlHeader, PROXY_REVALIDATE);
        }
        if (header.getMaxAge() != -1) {
            this.appendDirective(cacheControlHeader, MAX_AGE, header.getMaxAge());
        }
        if (header.getSMaxAge() != -1) {
            this.appendDirective(cacheControlHeader, S_MAXAGE, header.getSMaxAge());
        }
        if ((entrySet = header.getCacheExtension().entrySet()) != null && entrySet.size() > 0) {
            for (Map.Entry entry : entrySet) {
                this.appendExtentionDirective(cacheControlHeader, (String)entry.getKey(), this.quoteValue((String)entry.getValue()));
            }
        }
        return cacheControlHeader.toString();
    }

    private void appendDirective(StringBuffer cacheControlHeader, String directive) {
        if (cacheControlHeader.length() > 0) {
            cacheControlHeader.append(", ");
        }
        cacheControlHeader.append(directive);
    }

    private String generateDirectiveValuesList(List<String> values) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String value : values) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(value);
        }
        return stringBuffer.toString();
    }

    private void appendDirectiveWithValues(StringBuffer cacheControlHeader, String directive, String directiveValue) {
        this.appendDirective(cacheControlHeader, directive);
        if (directiveValue != null && directiveValue.length() > 0) {
            cacheControlHeader.append("=\"");
            cacheControlHeader.append(directiveValue);
            cacheControlHeader.append("\"");
        }
    }

    private void appendExtentionDirective(StringBuffer cacheControlHeader, String directive, String value) {
        this.appendDirective(cacheControlHeader, directive);
        if (value != null && value.length() > 0) {
            cacheControlHeader.append("=");
            cacheControlHeader.append(value);
        }
    }

    private void appendDirective(StringBuffer cacheControlHeader, String directive, int value) {
        this.appendDirective(cacheControlHeader, directive);
        cacheControlHeader.append("=");
        cacheControlHeader.append(value);
    }

    private String quoteValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.replaceAll("\\s+", "").length() < value.length()) {
            return "\"" + value + "\"";
        }
        return value;
    }
}

