/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.utils;

import java.math.BigInteger;
import javax.ws.rs.core.MediaType;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.model.opensearch.OpenSearchImage;

public class OpenSearchUtils {
    private static final BigInteger ICON_SIZE = BigInteger.valueOf(16L);
    private static final BigInteger IMG_SIZE = BigInteger.valueOf(64L);

    public static OpenSearchImage createOpenSearchImage(String mediaTypeString, String url) {
        if (mediaTypeString == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "mediaTypeString"));
        }
        OpenSearchImage image = new OpenSearchImage();
        MediaType mediaType = MediaType.valueOf((String)mediaTypeString);
        if (MediaTypeUtils.equalsIgnoreParameters(MediaTypeUtils.IMAGE_X_ICON_TYPE, mediaType) || MediaTypeUtils.equalsIgnoreParameters(MediaTypeUtils.IMAGE_VND_TYPE, mediaType)) {
            image.setHeight(ICON_SIZE);
            image.setWidth(ICON_SIZE);
            image.setType(mediaTypeString);
            image.setValue(url);
        } else if (MediaTypeUtils.equalsIgnoreParameters(MediaTypeUtils.IMAGE_PNG_TYPE, mediaType) || MediaTypeUtils.equalsIgnoreParameters(MediaTypeUtils.IMAGE_JPEG_TYPE, mediaType)) {
            image.setHeight(IMG_SIZE);
            image.setWidth(IMG_SIZE);
            image.setType(mediaTypeString);
            image.setValue(url);
        } else {
            image.setHeight(IMG_SIZE);
            image.setWidth(IMG_SIZE);
            image.setType(MediaTypeUtils.IMAGE_PNG_TYPE.toString());
            image.setValue(url);
        }
        return image;
    }
}

