/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.csv;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.wink.common.model.csv.CsvDeserializer;
import org.apache.wink.common.model.csv.CsvSerializer;
import org.apache.wink.common.model.csv.CsvTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiCsvTable
implements CsvSerializer,
CsvDeserializer {
    private static final String[] EMPTY_ARRAY = new String[0];
    private List<CsvTable> tablesList = new LinkedList<CsvTable>();
    private boolean needNewTable = true;

    public CsvTable createCsvTable(String ... header) {
        CsvTable table = new CsvTable(header);
        this.addTable(table);
        return table;
    }

    public void addTable(CsvTable table) {
        this.tablesList.add(table);
    }

    public List<CsvTable> getTables() {
        return this.tablesList;
    }

    @Override
    public Iterator<String[]> getEntities() {
        return new TablesIterator(this.tablesList.iterator());
    }

    @Override
    public void addEntity(String[] row) {
        if (row == null) {
            return;
        }
        if (this.isTableSeparator(row)) {
            this.needNewTable = true;
            return;
        }
        if (this.needNewTable) {
            this.createCsvTable(new String[0]);
            this.needNewTable = false;
        }
        CsvTable table = this.tablesList.get(this.tablesList.size() - 1);
        table.addRow(row);
    }

    private boolean isTableSeparator(String[] row) {
        if (row.length == 0) {
            return true;
        }
        return row.length == 1 && (row[0] == null || row[0].length() == 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TablesIterator
    implements Iterator<String[]> {
        private Iterator<CsvTable> tableIterator;
        private Iterator<String[]> rowIterator;

        public TablesIterator(Iterator<CsvTable> itr) {
            this.tableIterator = itr;
            this.rowIterator = itr.next().getEntities();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext() || this.tableIterator.hasNext();
        }

        @Override
        public String[] next() {
            if (!this.rowIterator.hasNext()) {
                this.rowIterator = this.tableIterator.next().getEntities();
                return EMPTY_ARRAY;
            }
            return this.rowIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

