/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import java.util.List;
import org.apache.neethi.Assertion;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.securityEvent.AbstractSecuredElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class OnlySignEntireHeadersAndBodyAssertionState
extends AssertionState
implements Assertable {
    private String roleOrActor;

    public OnlySignEntireHeadersAndBodyAssertionState(AbstractSecurityAssertion assertion, boolean asserted, String roleOrActor) {
        super((Assertion)assertion, asserted);
        this.roleOrActor = roleOrActor;
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{WSSecurityEventConstants.SignedPart, WSSecurityEventConstants.SignedElement};
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        AbstractSecuredElementSecurityEvent abstractSecuredElementSecurityEvent = (AbstractSecuredElementSecurityEvent)securityEvent;
        if (abstractSecuredElementSecurityEvent.isSigned() && !abstractSecuredElementSecurityEvent.isAttachment()) {
            List elementPath = abstractSecuredElementSecurityEvent.getElementPath();
            if (elementPath.size() == 4 && WSSUtils.isInSecurityHeader((XMLSecEvent)abstractSecuredElementSecurityEvent.getXmlSecEvent(), (List)elementPath, (String)this.roleOrActor)) {
                this.setAsserted(true);
                return true;
            }
            if (elementPath.size() == 3 && WSSUtils.isInSOAPHeader((List)elementPath)) {
                this.setAsserted(true);
                return true;
            }
            if (elementPath.size() == 2 && WSSUtils.isInSOAPBody((List)elementPath)) {
                this.setAsserted(true);
                return true;
            }
            this.setAsserted(false);
            this.setErrorMessage("OnlySignEntireHeadersAndBody not fulfilled, offending element: " + WSSUtils.pathAsString((List)elementPath));
            return false;
        }
        return true;
    }
}

