/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.stax.assertionStates;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.policy.AssertionState;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.SignedElements;
import org.apache.wss4j.policy.model.XPath;
import org.apache.wss4j.policy.stax.Assertable;
import org.apache.wss4j.policy.stax.PolicyUtils;
import org.apache.wss4j.stax.ext.WSSUtils;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.AbstractSecuredElementSecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class SignedElementsAssertionState
extends AssertionState
implements Assertable {
    private final List<List<QName>> pathElements = new ArrayList<List<QName>>();

    public SignedElementsAssertionState(AbstractSecurityAssertion assertion, boolean asserted) {
        super((Assertion)assertion, asserted);
        if (assertion instanceof SignedElements) {
            SignedElements signedElements = (SignedElements)assertion;
            for (int i = 0; i < signedElements.getXPaths().size(); ++i) {
                XPath xPath = (XPath)signedElements.getXPaths().get(i);
                List<QName> elements = PolicyUtils.getElementPath(xPath);
                this.pathElements.add(elements);
            }
        }
    }

    @Override
    public SecurityEventConstants.Event[] getSecurityEventType() {
        return new SecurityEventConstants.Event[]{SecurityEventConstants.SignedElement, WSSecurityEventConstants.SignedPart};
    }

    public void addElement(List<QName> pathElement) {
        this.pathElements.add(pathElement);
    }

    @Override
    public boolean assertEvent(SecurityEvent securityEvent) throws WSSPolicyException {
        AbstractSecuredElementSecurityEvent signedSecurityEvent = (AbstractSecuredElementSecurityEvent)securityEvent;
        for (List<QName> pathElements : this.pathElements) {
            if (!WSSUtils.pathMatches(pathElements, (List)signedSecurityEvent.getElementPath(), (boolean)true, (boolean)false)) continue;
            if (signedSecurityEvent.isSigned()) {
                this.setAsserted(true);
                return true;
            }
            this.setAsserted(false);
            this.setErrorMessage("Element " + WSSUtils.pathAsString((List)signedSecurityEvent.getElementPath()) + " must be signed");
            return false;
        }
        return true;
    }
}

