/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.authentication;

import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.token.TokenAuthenticationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.authentication.TokenAuthenticationSecurity;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class TokenAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationHandler.class);
    private final ServicesManager servicesManager;

    public TokenAuthenticationHandler(ServicesManager servicesManager, PrincipalFactory principalFactory, TokenAuthenticationProperties properties) {
        super(properties.getName(), principalFactory, Integer.valueOf(properties.getOrder()));
        this.servicesManager = servicesManager;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws PreventedException {
        try {
            BasicIdentifiableCredential tokenCredential = (BasicIdentifiableCredential)credential;
            RegisteredService registeredService = this.servicesManager.findServiceBy(service);
            UserProfile profile = TokenAuthenticationSecurity.forRegisteredService(registeredService).validateToken(tokenCredential.getId());
            Assert.notNull((Object)profile, (String)"Authentication attempt failed to produce an authenticated profile");
            Map attributes = CollectionUtils.toMultiValuedMap((Map)profile.getAttributes());
            Principal principal = this.principalFactory.createPrincipal(profile.getId(), attributes);
            tokenCredential.setId(principal.getId());
            return this.createHandlerResult((Credential)tokenCredential, principal, new ArrayList());
        }
        catch (Throwable e) {
            throw new AuthenticationException(e);
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof BasicIdentifiableCredential;
    }
}

