/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.authentication;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.Base64;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.apereo.cas.util.crypto.PublicKeyFactoryBean;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jwt.config.encryption.EncryptionConfiguration;
import org.pac4j.jwt.config.encryption.RSAEncryptionConfiguration;
import org.pac4j.jwt.config.encryption.SecretEncryptionConfiguration;
import org.pac4j.jwt.config.signature.RSASignatureConfiguration;
import org.pac4j.jwt.config.signature.SecretSignatureConfiguration;
import org.pac4j.jwt.config.signature.SignatureConfiguration;
import org.pac4j.jwt.credentials.authenticator.JwtAuthenticator;
import org.pac4j.jwt.profile.JwtGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class TokenAuthenticationSecurity {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationSecurity.class);
    private RegisteredServiceSecurityConfiguration securityConfiguration;

    public String generateTokenFor(Authentication authentication) {
        HashMap<String, String> claims = new HashMap<String, String>(authentication.getAttributes());
        claims.putAll(authentication.getPrincipal().getAttributes());
        claims.put("sub", authentication.getPrincipal().getId());
        return this.toGenerator().generate(CollectionUtils.toSingleValuedMap(claims, List.of("jti", "iss", "nbf", "iat", "exp")));
    }

    public UserProfile validateToken(String token) {
        return this.toAuthenticator().validateToken(token);
    }

    public static TokenAuthenticationSecurity forRegisteredService(RegisteredService registeredService) {
        RegisteredServiceSecurityConfiguration securityConfiguration = new RegisteredServiceSecurityConfiguration();
        SignatureConfiguration signingConfig = TokenAuthenticationSecurity.getSignatureConfiguration(registeredService);
        EncryptionConfiguration encConfig = TokenAuthenticationSecurity.getEncryptionConfiguration(registeredService);
        securityConfiguration.setEncryptionConfiguration(encConfig);
        securityConfiguration.setSignatureConfiguration(signingConfig);
        return new TokenAuthenticationSecurity(securityConfiguration);
    }

    public JwtGenerator toGenerator() {
        JwtGenerator generator = new JwtGenerator();
        FunctionUtils.doIfNotNull((Object)this.securityConfiguration.getSignatureConfiguration(), arg_0 -> ((JwtGenerator)generator).setSignatureConfiguration(arg_0));
        FunctionUtils.doIfNotNull((Object)this.securityConfiguration.getEncryptionConfiguration(), arg_0 -> ((JwtGenerator)generator).setEncryptionConfiguration(arg_0));
        return generator;
    }

    public JwtAuthenticator toAuthenticator() {
        JwtAuthenticator authn = new JwtAuthenticator();
        FunctionUtils.doIfNotNull((Object)this.securityConfiguration.getEncryptionConfiguration(), arg_0 -> ((JwtAuthenticator)authn).setEncryptionConfiguration(arg_0));
        FunctionUtils.doIfNotNull((Object)this.securityConfiguration.getSignatureConfiguration(), arg_0 -> ((JwtAuthenticator)authn).setSignatureConfiguration(arg_0));
        return authn;
    }

    private static String getRegisteredServiceJwtProperty(RegisteredService registeredService, RegisteredServiceProperty.RegisteredServiceProperties propName) {
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed(registeredService, null)) {
            LOGGER.debug("Service is not defined/found or its access is disabled in the registry");
            throw UnauthorizedServiceException.denied((String)"Denied");
        }
        if (propName.isAssignedTo(registeredService)) {
            String propertyValue = propName.getPropertyValue(registeredService).value();
            return SpringExpressionLanguageValueResolver.getInstance().resolve(propertyValue);
        }
        LOGGER.trace("Service [{}] does not define a property [{}] in the registry", (Object)registeredService.getServiceId(), (Object)propName);
        return null;
    }

    private static SignatureConfiguration getSignatureConfiguration(RegisteredService registeredService) {
        String signingSecret = TokenAuthenticationSecurity.getRegisteredServiceJwtSigningSecret(registeredService);
        if (StringUtils.isNotBlank((CharSequence)signingSecret)) {
            JWSAlgorithm signingAlg = TokenAuthenticationSecurity.determineSigningAlgorithm(registeredService);
            if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)signingAlg)) {
                byte[] secretBytes = TokenAuthenticationSecurity.getSecretBytes(signingSecret, TokenAuthenticationSecurity.areSecretsBase64Encoded(registeredService));
                return new SecretSignatureConfiguration(secretBytes, signingAlg);
            }
            if (JWSAlgorithm.Family.RSA.contains((Object)signingAlg)) {
                RSAPrivateKey privateKey = TokenAuthenticationSecurity.getRsaPrivateKey(signingSecret);
                String encryptionSecret = TokenAuthenticationSecurity.getRegisteredServiceJwtEncryptionSecret(registeredService);
                RSAPublicKey publicKey = StringUtils.isNotBlank((CharSequence)encryptionSecret) ? TokenAuthenticationSecurity.getRsaPublicKey(encryptionSecret) : null;
                RSASignatureConfiguration config = new RSASignatureConfiguration();
                config.setAlgorithm(signingAlg);
                config.setPrivateKey(privateKey);
                config.setPublicKey(publicKey);
                return config;
            }
        }
        return null;
    }

    private static EncryptionConfiguration getEncryptionConfiguration(RegisteredService registeredService) {
        String encryptionSecret = TokenAuthenticationSecurity.getRegisteredServiceJwtEncryptionSecret(registeredService);
        if (StringUtils.isNotBlank((CharSequence)encryptionSecret)) {
            JWEAlgorithm encryptionAlgorithm = TokenAuthenticationSecurity.determineEncryptionAlgorithm(registeredService);
            EncryptionMethod encryptionMethod = TokenAuthenticationSecurity.determineEncryptionMethod(registeredService);
            if (JWEAlgorithm.Family.RSA.contains((Object)encryptionAlgorithm)) {
                RSAPublicKey publicKey = TokenAuthenticationSecurity.getRsaPublicKey(encryptionSecret);
                String signingSecret = TokenAuthenticationSecurity.getRegisteredServiceJwtSigningSecret(registeredService);
                RSAPrivateKey privateKey = StringUtils.isNotBlank((CharSequence)signingSecret) ? TokenAuthenticationSecurity.getRsaPrivateKey(signingSecret) : null;
                RSAEncryptionConfiguration config = new RSAEncryptionConfiguration();
                config.setAlgorithm(encryptionAlgorithm);
                config.setMethod(encryptionMethod);
                config.setPublicKey(publicKey);
                config.setPrivateKey(privateKey);
                return config;
            }
            byte[] encSecretBytes = TokenAuthenticationSecurity.getSecretBytes(encryptionSecret, TokenAuthenticationSecurity.areSecretsBase64Encoded(registeredService));
            return new SecretEncryptionConfiguration(encSecretBytes, encryptionAlgorithm, encryptionMethod);
        }
        return null;
    }

    private static RSAPublicKey getRsaPublicKey(String encryptionSecret) {
        return (RSAPublicKey)FunctionUtils.doUnchecked(() -> {
            AbstractResource resource = ResourceUtils.getResourceFrom((String)encryptionSecret);
            PublicKeyFactoryBean factory = new PublicKeyFactoryBean((Resource)resource, "RSA");
            factory.setSingleton(false);
            return (RSAPublicKey)factory.getObject();
        });
    }

    private static RSAPrivateKey getRsaPrivateKey(String signingSecret) {
        return (RSAPrivateKey)FunctionUtils.doUnchecked(() -> {
            AbstractResource resource = ResourceUtils.getResourceFrom((String)signingSecret);
            PrivateKeyFactoryBean factory = new PrivateKeyFactoryBean();
            factory.setAlgorithm("RSA");
            factory.setLocation((Resource)resource);
            factory.setSingleton(false);
            return (RSAPrivateKey)factory.getObject();
        });
    }

    private static JWSAlgorithm determineSigningAlgorithm(RegisteredService registeredService) {
        String serviceSigningAlg = TokenAuthenticationSecurity.getRegisteredServiceJwtProperty(registeredService, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_SIGNING_ALG);
        String signingSecretAlg = (String)StringUtils.defaultIfBlank((CharSequence)serviceSigningAlg, (CharSequence)JWSAlgorithm.HS256.getName());
        HashSet<Algorithm> sets = new HashSet<Algorithm>();
        sets.addAll((Collection<Algorithm>)JWSAlgorithm.Family.EC);
        sets.addAll((Collection<Algorithm>)JWSAlgorithm.Family.HMAC_SHA);
        sets.addAll((Collection<Algorithm>)JWSAlgorithm.Family.RSA);
        sets.addAll((Collection<Algorithm>)JWSAlgorithm.Family.SIGNATURE);
        return TokenAuthenticationSecurity.findAlgorithmFamily(sets, signingSecretAlg, JWSAlgorithm.class);
    }

    private static EncryptionMethod determineEncryptionMethod(RegisteredService registeredService) {
        HashSet<Algorithm> encryptionMethods = new HashSet<Algorithm>();
        encryptionMethods.addAll((Collection<Algorithm>)EncryptionMethod.Family.AES_CBC_HMAC_SHA);
        encryptionMethods.addAll((Collection<Algorithm>)EncryptionMethod.Family.AES_GCM);
        String encryptionMethod = TokenAuthenticationSecurity.getRegisteredServiceJwtProperty(registeredService, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION_METHOD);
        String encryptionSecretMethod = (String)StringUtils.defaultIfBlank((CharSequence)encryptionMethod, (CharSequence)EncryptionMethod.A192CBC_HS384.getName());
        return TokenAuthenticationSecurity.findAlgorithmFamily(encryptionMethods, encryptionSecretMethod, EncryptionMethod.class);
    }

    private static JWEAlgorithm determineEncryptionAlgorithm(RegisteredService registeredService) {
        HashSet<Algorithm> sets = new HashSet<Algorithm>();
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.AES_GCM_KW);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.AES_KW);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.ASYMMETRIC);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.ECDH_ES);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.PBES2);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.RSA);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.SYMMETRIC);
        String encryptionAlg = TokenAuthenticationSecurity.getRegisteredServiceJwtProperty(registeredService, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION_ALG);
        String encryptionSecretAlg = (String)StringUtils.defaultIfBlank((CharSequence)encryptionAlg, (CharSequence)JWEAlgorithm.DIR.getName());
        return TokenAuthenticationSecurity.findAlgorithmFamily(sets, encryptionSecretAlg, JWEAlgorithm.class);
    }

    private static String getRegisteredServiceJwtEncryptionSecret(RegisteredService registeredService) {
        return TokenAuthenticationSecurity.getRegisteredServiceJwtProperty(registeredService, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION);
    }

    private static String getRegisteredServiceJwtSigningSecret(RegisteredService registeredService) {
        return TokenAuthenticationSecurity.getRegisteredServiceJwtProperty(registeredService, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_SIGNING);
    }

    private static boolean areSecretsBase64Encoded(RegisteredService registeredService) {
        String secretIsBase64 = TokenAuthenticationSecurity.getRegisteredServiceJwtProperty(registeredService, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRETS_ARE_BASE64_ENCODED);
        return BooleanUtils.toBoolean((String)secretIsBase64);
    }

    private static <T extends Algorithm> T findAlgorithmFamily(Set<Algorithm> family, String alg, Class<T> clazz) {
        Optional<Algorithm> result = family.stream().filter(algorithm -> algorithm.getName().equalsIgnoreCase(alg)).findFirst();
        if (result.isPresent()) {
            Algorithm algorithm2 = result.get();
            if (!clazz.isAssignableFrom(algorithm2.getClass())) {
                throw new ClassCastException("Result [%s is of type %s when we were expecting %s".formatted(algorithm2, algorithm2.getClass(), clazz));
            }
            return (T)algorithm2;
        }
        throw new IllegalArgumentException("Unable to find algorithm " + alg);
    }

    private static byte[] getSecretBytes(String secret, boolean secretIsBase64Encoded) {
        return secretIsBase64Encoded ? new Base64(secret).decode() : secret.getBytes(StandardCharsets.UTF_8);
    }

    @Generated
    protected TokenAuthenticationSecurity(RegisteredServiceSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    private static final class RegisteredServiceSecurityConfiguration {
        private SignatureConfiguration signatureConfiguration;
        private EncryptionConfiguration encryptionConfiguration;

        @Generated
        public RegisteredServiceSecurityConfiguration() {
        }

        @Generated
        public SignatureConfiguration getSignatureConfiguration() {
            return this.signatureConfiguration;
        }

        @Generated
        public EncryptionConfiguration getEncryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegisteredServiceSecurityConfiguration)) {
                return false;
            }
            RegisteredServiceSecurityConfiguration other = (RegisteredServiceSecurityConfiguration)o;
            SignatureConfiguration this$signatureConfiguration = this.signatureConfiguration;
            SignatureConfiguration other$signatureConfiguration = other.signatureConfiguration;
            if (this$signatureConfiguration == null ? other$signatureConfiguration != null : !this$signatureConfiguration.equals(other$signatureConfiguration)) {
                return false;
            }
            EncryptionConfiguration this$encryptionConfiguration = this.encryptionConfiguration;
            EncryptionConfiguration other$encryptionConfiguration = other.encryptionConfiguration;
            return !(this$encryptionConfiguration == null ? other$encryptionConfiguration != null : !this$encryptionConfiguration.equals(other$encryptionConfiguration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SignatureConfiguration $signatureConfiguration = this.signatureConfiguration;
            result = result * 59 + ($signatureConfiguration == null ? 43 : $signatureConfiguration.hashCode());
            EncryptionConfiguration $encryptionConfiguration = this.encryptionConfiguration;
            result = result * 59 + ($encryptionConfiguration == null ? 43 : $encryptionConfiguration.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TokenAuthenticationSecurity.RegisteredServiceSecurityConfiguration(signatureConfiguration=" + String.valueOf(this.signatureConfiguration) + ", encryptionConfiguration=" + String.valueOf(this.encryptionConfiguration) + ")";
        }

        @Generated
        public void setSignatureConfiguration(SignatureConfiguration signatureConfiguration) {
            this.signatureConfiguration = signatureConfiguration;
        }

        @Generated
        public void setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
        }
    }
}

