/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.TokenAuthenticationEndpoint;
import org.apereo.cas.web.TokenRequestExtractor;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.TokenAuthenticationAction;
import org.apereo.cas.web.flow.TokenWebflowConfigurer;
import org.apereo.cas.web.flow.actions.WebflowActionBeanSupplier;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Authentication}, module="token")
@AutoConfiguration
public class CasTokenAuthenticationWebflowAutoConfiguration {
    @ConditionalOnMissingBean(name={"tokenWebflowConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasWebflowConfigurer tokenWebflowConfigurer(@Qualifier(value="flowDefinitionRegistry") FlowDefinitionRegistry flowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        return new TokenWebflowConfigurer(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"tokenRequestExtractor"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TokenRequestExtractor tokenRequestExtractor() {
        return TokenRequestExtractor.defaultExtractor();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"tokenAuthenticationAction"})
    public Action tokenAuthenticationAction(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="tokenRequestExtractor") TokenRequestExtractor tokenRequestExtractor, @Qualifier(value="adaptiveAuthenticationPolicy") AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, @Qualifier(value="serviceTicketRequestWebflowEventResolver") CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
        return WebflowActionBeanSupplier.builder().withApplicationContext((ApplicationContext)applicationContext).withProperties(casProperties).withAction(() -> new TokenAuthenticationAction(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy, tokenRequestExtractor, servicesManager, webApplicationServiceFactory, authenticationServiceSelectionPlan, casProperties)).withId("tokenAuthenticationAction").build().get();
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"tokenCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer tokenCasWebflowExecutionPlanConfigurer(@Qualifier(value="tokenWebflowConfigurer") CasWebflowConfigurer tokenWebflowConfigurer) {
        return plan -> plan.registerWebflowConfigurer(tokenWebflowConfigurer);
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TokenAuthenticationEndpoint tokenAuthenticationEndpoint(ObjectProvider<CasConfigurationProperties> casProperties, @Qualifier(value="defaultPrincipalResolver") ObjectProvider<PrincipalResolver> defaultPrincipalResolver, @Qualifier(value="servicesManager") ObjectProvider<ServicesManager> servicesManager, @Qualifier(value="registeredServiceAccessStrategyEnforcer") ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer, @Qualifier(value="webApplicationServiceFactory") ObjectProvider<ServiceFactory<WebApplicationService>> webApplicationServiceFactory, @Qualifier(value="principalFactory") ObjectProvider<PrincipalFactory> principalFactory) {
        return new TokenAuthenticationEndpoint(casProperties, defaultPrincipalResolver, servicesManager, registeredServiceAccessStrategyEnforcer, webApplicationServiceFactory, principalFactory);
    }
}

