/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.authentication.TokenAuthenticationSecurity;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.BaseCasActuatorEndpoint;
import org.pac4j.core.profile.UserProfile;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.util.Assert;

@Endpoint(id="tokenAuth", defaultAccess=Access.NONE)
public class TokenAuthenticationEndpoint
extends BaseCasActuatorEndpoint {
    private final ObjectProvider<PrincipalResolver> principalResolver;
    private final ObjectProvider<ServicesManager> servicesManager;
    private final ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    private final ObjectProvider<ServiceFactory<WebApplicationService>> serviceFactory;
    private final ObjectProvider<PrincipalFactory> principalFactory;

    public TokenAuthenticationEndpoint(ObjectProvider<CasConfigurationProperties> casProperties, ObjectProvider<PrincipalResolver> principalResolver, ObjectProvider<ServicesManager> servicesManager, ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer, ObjectProvider<ServiceFactory<WebApplicationService>> serviceFactory, ObjectProvider<PrincipalFactory> principalFactory) {
        super((CasConfigurationProperties)casProperties.getObject());
        this.principalResolver = principalResolver;
        this.servicesManager = servicesManager;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.serviceFactory = serviceFactory;
        this.principalFactory = principalFactory;
    }

    @WriteOperation(produces={"application/json"})
    @Operation(summary="Produce an authentication token for the user and the intended application", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to authenticate"), @Parameter(name="service", required=true, in=ParameterIn.QUERY, description="May be the service id or its numeric identifier")})
    public Map<?, ?> produceToken(@Selector String username, String service) throws Throwable {
        WebApplicationService selectedService = (WebApplicationService)((ServiceFactory)this.serviceFactory.getObject()).createService(service);
        RegisteredService registeredService = NumberUtils.isCreatable((String)service) ? ((ServicesManager)this.servicesManager.getObject()).findServiceBy(Long.parseLong(service)) : ((ServicesManager)this.servicesManager.getObject()).findServiceBy((Service)selectedService);
        Principal principal = ((PrincipalResolver)this.principalResolver.getObject()).resolve((Credential)new BasicIdentifiableCredential(username), Optional.of(((PrincipalFactory)this.principalFactory.getObject()).createPrincipal(username)), Optional.empty(), Optional.of(selectedService));
        Authentication authentication = DefaultAuthenticationBuilder.newInstance().setPrincipal(principal).build();
        AuditableContext audit = AuditableContext.builder().service((Service)selectedService).authentication(authentication).registeredService(registeredService).build();
        AuditableExecutionResult accessResult = ((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).execute(audit);
        accessResult.throwExceptionIfNeeded();
        String token = TokenAuthenticationSecurity.forRegisteredService((RegisteredService)registeredService).generateTokenFor(authentication);
        return Map.of("registeredService", registeredService, "token", token);
    }

    @ReadOperation(produces={"application/json"})
    @Operation(summary="Validate an authentication token for the user and the intended application", parameters={@Parameter(name="token", required=true, in=ParameterIn.PATH, description="The token to validate"), @Parameter(name="service", required=true, in=ParameterIn.QUERY, description="May be the service id or its numeric identifier")})
    public Map<?, ?> validateToken(@Selector String token, String service) throws Throwable {
        WebApplicationService selectedService = (WebApplicationService)((ServiceFactory)this.serviceFactory.getObject()).createService(service);
        RegisteredService registeredService = NumberUtils.isCreatable((String)service) ? ((ServicesManager)this.servicesManager.getObject()).findServiceBy(Long.parseLong(service)) : ((ServicesManager)this.servicesManager.getObject()).findServiceBy((Service)selectedService);
        UserProfile profile = TokenAuthenticationSecurity.forRegisteredService((RegisteredService)registeredService).validateToken(token);
        Assert.notNull((Object)profile, (String)"Authentication attempt failed to produce an authenticated profile");
        Map attributes = CollectionUtils.toMultiValuedMap((Map)profile.getAttributes());
        Principal principal = ((PrincipalFactory)this.principalFactory.getObject()).createPrincipal(profile.getId(), attributes);
        AuditableContext audit = AuditableContext.builder().service((Service)selectedService).principal(principal).registeredService(registeredService).build();
        AuditableExecutionResult accessResult = ((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).execute(audit);
        accessResult.throwExceptionIfNeeded();
        return Map.of("registeredService", registeredService, "principal", principal);
    }
}

