/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class TokenWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    public TokenWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
        this.setOrder(casProperties.getAuthn().getToken().getWebflow().getOrder());
    }

    protected void doInitialize() {
        Flow flow = this.getLoginFlow();
        if (flow != null) {
            ActionState actionState = this.createActionState(flow, "tokenAuthenticationCheck", (Action)this.createEvaluateAction("tokenAuthenticationAction"));
            actionState.getTransitionSet().add(this.createTransition("success", "createTicketGrantingTicket"));
            actionState.getExitActionList().add((Action)this.createEvaluateAction("clearWebflowCredentialsAction"));
            this.createStateDefaultTransition((TransitionableState)actionState, this.getStartState(flow).getId());
            this.setStartState(flow, (TransitionableState)actionState);
        }
    }
}

