/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.sql.resultsetcollector;

import java.util.List;
import net.sf.log4jdbc.sql.resultsetcollector.ResultSetCollector;

public class ResultSetCollectorPrinter {
    private StringBuffer table = new StringBuffer();

    public String getResultSetToPrint(ResultSetCollector resultSetCollector) {
        int colIndex;
        int column;
        this.table.append(System.getProperty("line.separator"));
        int columnCount = resultSetCollector.getColumnCount();
        int[] maxLength = new int[columnCount];
        for (column = 1; column <= columnCount; ++column) {
            maxLength[column - 1] = resultSetCollector.getColumnName(column).length();
        }
        if (resultSetCollector.getRows() != null) {
            for (List<Object> printRow : resultSetCollector.getRows()) {
                colIndex = 0;
                for (Object v : printRow) {
                    int length;
                    if (v != null && (length = v.toString().length()) > maxLength[colIndex]) {
                        maxLength[colIndex] = length;
                    }
                    ++colIndex;
                }
            }
        }
        for (column = 1; column <= columnCount; ++column) {
            maxLength[column - 1] = maxLength[column - 1] + 1;
        }
        this.table.append("|");
        for (column = 1; column <= columnCount; ++column) {
            this.table.append(ResultSetCollectorPrinter.padRight("-", maxLength[column - 1]).replaceAll(" ", "-") + "|");
        }
        this.table.append(System.getProperty("line.separator"));
        this.table.append("|");
        for (column = 1; column <= columnCount; ++column) {
            this.table.append(ResultSetCollectorPrinter.padRight(resultSetCollector.getColumnName(column), maxLength[column - 1]) + "|");
        }
        this.table.append(System.getProperty("line.separator"));
        this.table.append("|");
        for (column = 1; column <= columnCount; ++column) {
            this.table.append(ResultSetCollectorPrinter.padRight("-", maxLength[column - 1]).replaceAll(" ", "-") + "|");
        }
        this.table.append(System.getProperty("line.separator"));
        if (resultSetCollector.getRows() != null) {
            for (List<Object> printRow : resultSetCollector.getRows()) {
                colIndex = 0;
                this.table.append("|");
                for (Object v : printRow) {
                    this.table.append(ResultSetCollectorPrinter.padRight(v == null ? "null" : v.toString(), maxLength[colIndex]) + "|");
                    ++colIndex;
                }
                this.table.append(System.getProperty("line.separator"));
            }
        }
        this.table.append("|");
        for (int column2 = 1; column2 <= columnCount; ++column2) {
            this.table.append(ResultSetCollectorPrinter.padRight("-", maxLength[column2 - 1]).replaceAll(" ", "-") + "|");
        }
        this.table.append(System.getProperty("line.separator"));
        resultSetCollector.reset();
        return this.table.toString();
    }

    private static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }
}

