/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import java.lang.ref.Reference;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.GCMSIVModeCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AESNativeGCMSIV
implements GCMSIVModeCipher {
    private GCMSIVRefWrapper refWrapper;
    private byte[] keptMac;
    private final GCMSIVCache theEncData = new GCMSIVCache();
    private boolean forEncryption;
    private byte[] theNonce;
    private byte[] theInitialAEAD;

    @Override
    public BlockCipher getUnderlyingCipher() {
        try {
            MultiBlockCipher multiBlockCipher = AESEngine.newInstance();
            if (this.refWrapper != null && this.refWrapper.key != null) {
                multiBlockCipher.init(true, new KeyParameter(this.refWrapper.key));
            }
            MultiBlockCipher multiBlockCipher2 = multiBlockCipher;
            return multiBlockCipher2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        try {
            KeyParameter keyParameter;
            byte[] byArray;
            Object object;
            this.forEncryption = bl;
            this.keptMac = null;
            this.theEncData.reset();
            byte[] byArray2 = null;
            if (cipherParameters instanceof AEADParameters) {
                object = (AEADParameters)cipherParameters;
                byArray2 = ((AEADParameters)object).getAssociatedText();
                byArray = ((AEADParameters)object).getNonce();
                keyParameter = ((AEADParameters)object).getKey();
            } else if (cipherParameters instanceof ParametersWithIV) {
                object = (ParametersWithIV)cipherParameters;
                byArray = ((ParametersWithIV)object).getIV();
                keyParameter = (KeyParameter)((ParametersWithIV)object).getParameters();
            } else {
                throw new IllegalArgumentException("invalid parameters passed to GCM-SIV");
            }
            this.theInitialAEAD = byArray2;
            this.theNonce = byArray;
            object = keyParameter.getKey();
            switch (((Object)object).length) {
                case 16: 
                case 24: 
                case 32: {
                    break;
                }
                default: {
                    throw new IllegalStateException("key must be only 16, 24 or 32 bytes long");
                }
            }
            this.initRef((byte[])object);
            AESNativeGCMSIV.initNative(this.refWrapper.getReference(), bl, this.refWrapper.key, this.theNonce, this.theInitialAEAD);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    private void initRef(byte[] byArray) {
        this.refWrapper = new GCMSIVRefWrapper(AESNativeGCMSIV.makeInstance(), byArray);
    }

    @Override
    public String getAlgorithmName() {
        return "AES/GCM-SIV";
    }

    @Override
    public void processAADByte(byte by) {
        try {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM-SIV is uninitialized");
            }
            AESNativeGCMSIV.processAADByte(this.refWrapper.getReference(), by);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processAADBytes(byte[] byArray, int n, int n2) {
        try {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM-SIV is uninitialized");
            }
            AESNativeGCMSIV.processAADBytes(this.refWrapper.getReference(), byArray, n, n2);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
        try {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM-SIV is uninitialized");
            }
            this.theEncData.write(by);
            int n2 = 0;
            return n2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        try {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM-SIV is uninitialized");
            }
            this.theEncData.write(byArray, n, n2);
            int n4 = 0;
            return n4;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        try {
            int n2 = AESNativeGCMSIV.doFinal(this.refWrapper.getReference(), this.theEncData.getBuffer(), this.theEncData.size(), byArray, n);
            this.keptMac = this.getMac();
            this.reset();
            int n3 = n2;
            return n3;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public byte[] getMac() {
        try {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM-SIV is uninitialized");
            }
            if (this.keptMac != null) {
                byte[] byArray = Arrays.clone(this.keptMac);
                return byArray;
            }
            byte[] byArray = AESNativeGCMSIV.getMac(this.refWrapper.getReference());
            return byArray;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int getUpdateOutputSize(int n) {
        try {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM-SIV is uninitialized");
            }
            int n2 = AESNativeGCMSIV.getUpdateOutputSize(this.refWrapper.getReference(), n, this.theEncData.size());
            return n2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public int getOutputSize(int n) {
        try {
            if (this.refWrapper == null) {
                throw new IllegalStateException("GCM-SIV is uninitialized");
            }
            int n2 = AESNativeGCMSIV.getOutputSize(this.refWrapper.getReference(), n);
            return n2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public void reset() {
        try {
            this.theEncData.clearBuffer();
            if (this.refWrapper == null) {
                return;
            }
            this.reset(this.refWrapper.getReference());
            AESNativeGCMSIV.initNative(this.refWrapper.getReference(), this.forEncryption, this.refWrapper.key, this.theNonce, this.theInitialAEAD);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public String toString() {
        try {
            if (this.refWrapper != null && this.refWrapper.key != null) {
                String string = "GCMSIV[Native](AES[Native](" + this.refWrapper.key.length * 8 + "))";
                return string;
            }
            String string = "GCMSIV[Native](AES[Native](not initialized))";
            return string;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    private native void reset(long var1);

    static native void initNative(long var0, boolean var2, byte[] var3, byte[] var4, byte[] var5);

    static native long makeInstance();

    static native void dispose(long var0);

    static native void processAADByte(long var0, byte var2);

    static native void processAADBytes(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3, byte[] var4, int var5);

    static native int getUpdateOutputSize(long var0, int var2, int var3);

    static native int getOutputSize(long var0, int var2);

    static native byte[] getMac(long var0);

    static native void test_set_max_dl(long var0, long var2);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class GCMSIVCache
    extends ByteArrayOutputStream {
        GCMSIVCache() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        void clearBuffer() {
            Arrays.fill(this.getBuffer(), (byte)0);
            this.reset();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class GCMSIVRefWrapper
    extends NativeReference {
        private final byte[] key;

        public GCMSIVRefWrapper(long l, byte[] byArray) {
            super(l, "GCM-SIV");
            this.key = byArray;
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference, this.key);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Disposer
    extends NativeDisposer {
        private final byte[] key;

        Disposer(long l, byte[] byArray) {
            super(l);
            this.key = byArray;
        }

        @Override
        protected void dispose(long l) {
            Arrays.clear(this.key);
            AESNativeGCMSIV.dispose(l);
        }
    }
}

