/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.impl.AbstractQueryVariableValueCondition;
import org.camunda.bpm.engine.impl.QueryVariableValue;
import org.camunda.bpm.engine.impl.SingleQueryVariableValueCondition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.type.ValueTypeResolver;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class CompositeQueryVariableValueCondition
extends AbstractQueryVariableValueCondition {
    protected List<SingleQueryVariableValueCondition> aggregatedValues = new ArrayList<SingleQueryVariableValueCondition>();

    public CompositeQueryVariableValueCondition(QueryVariableValue variableValue) {
        super(variableValue);
    }

    @Override
    public void initializeValue(VariableSerializers serializers) {
        TypedValue typedValue = this.wrappedQueryValue.getTypedValue();
        ValueTypeResolver resolver = Context.getProcessEngineConfiguration().getValueTypeResolver();
        Collection concreteTypes = resolver.getSubTypes(typedValue.getType());
        for (ValueType type : concreteTypes) {
            if (!type.canConvertFromTypedValue(typedValue)) continue;
            TypedValue convertedValue = type.convertFromTypedValue(typedValue);
            SingleQueryVariableValueCondition aggregatedValue = new SingleQueryVariableValueCondition(this.wrappedQueryValue);
            aggregatedValue.initializeValue(serializers, convertedValue);
            this.aggregatedValues.add(aggregatedValue);
        }
    }

    @Override
    public List<SingleQueryVariableValueCondition> getDisjunctiveConditions() {
        return this.aggregatedValues;
    }
}

