/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.configuration;

import java.util.List;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionEvaluationListener;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnElementTransformHandler;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.camunda.bpm.engine.impl.dmn.el.ProcessEngineElProvider;
import org.camunda.bpm.engine.impl.dmn.transformer.DecisionDefinitionHandler;
import org.camunda.bpm.engine.impl.dmn.transformer.DecisionRequirementsDefinitionTransformHandler;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.parser.HistoryDecisionEvaluationListener;
import org.camunda.bpm.engine.impl.history.producer.DmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.metrics.dmn.MetricsDecisionEvaluationListener;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.Definitions;

public class DmnEngineConfigurationBuilder {
    protected final DefaultDmnEngineConfiguration dmnEngineConfiguration;
    protected HistoryLevel historyLevel;
    protected DmnHistoryEventProducer dmnHistoryEventProducer;
    protected DmnScriptEngineResolver scriptEngineResolver;
    protected ExpressionManager expressionManager;

    public DmnEngineConfigurationBuilder(DefaultDmnEngineConfiguration dmnEngineConfiguration) {
        EnsureUtil.ensureNotNull("dmnEngineConfiguration", (Object)dmnEngineConfiguration);
        this.dmnEngineConfiguration = dmnEngineConfiguration;
    }

    public DmnEngineConfigurationBuilder historyLevel(HistoryLevel historyLevel) {
        this.historyLevel = historyLevel;
        return this;
    }

    public DmnEngineConfigurationBuilder dmnHistoryEventProducer(DmnHistoryEventProducer dmnHistoryEventProducer) {
        this.dmnHistoryEventProducer = dmnHistoryEventProducer;
        return this;
    }

    public DmnEngineConfigurationBuilder scriptEngineResolver(DmnScriptEngineResolver scriptEngineResolver) {
        this.scriptEngineResolver = scriptEngineResolver;
        return this;
    }

    public DmnEngineConfigurationBuilder expressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    public DefaultDmnEngineConfiguration build() {
        List<DmnDecisionEvaluationListener> decisionEvaluationListeners = this.createCustomPostDecisionEvaluationListeners();
        this.dmnEngineConfiguration.setCustomPostDecisionEvaluationListeners(decisionEvaluationListeners);
        DmnTransformer dmnTransformer = this.dmnEngineConfiguration.getTransformer();
        dmnTransformer.getElementTransformHandlerRegistry().addHandler(Definitions.class, (DmnElementTransformHandler)new DecisionRequirementsDefinitionTransformHandler());
        dmnTransformer.getElementTransformHandlerRegistry().addHandler(Decision.class, (DmnElementTransformHandler)new DecisionDefinitionHandler());
        if (this.dmnEngineConfiguration.getScriptEngineResolver() == null) {
            EnsureUtil.ensureNotNull("scriptEngineResolver", (Object)this.scriptEngineResolver);
            this.dmnEngineConfiguration.setScriptEngineResolver(this.scriptEngineResolver);
        }
        if (this.dmnEngineConfiguration.getElProvider() == null) {
            EnsureUtil.ensureNotNull("expressionManager", (Object)this.expressionManager);
            ProcessEngineElProvider elProvider = new ProcessEngineElProvider(this.expressionManager);
            this.dmnEngineConfiguration.setElProvider((ElProvider)elProvider);
        }
        return this.dmnEngineConfiguration;
    }

    protected List<DmnDecisionEvaluationListener> createCustomPostDecisionEvaluationListeners() {
        EnsureUtil.ensureNotNull("dmnHistoryEventProducer", (Object)this.dmnHistoryEventProducer);
        HistoryDecisionEvaluationListener historyDecisionEvaluationListener = new HistoryDecisionEvaluationListener(this.dmnHistoryEventProducer, this.historyLevel);
        List customPostDecisionEvaluationListeners = this.dmnEngineConfiguration.getCustomPostDecisionEvaluationListeners();
        customPostDecisionEvaluationListeners.add(new MetricsDecisionEvaluationListener());
        customPostDecisionEvaluationListeners.add(historyDecisionEvaluationListener);
        return customPostDecisionEvaluationListeners;
    }
}

