/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.AbstractSetJobRetriesCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;

public class SetJobRetriesCmd
extends AbstractSetJobRetriesCmd
implements Command<Void>,
Serializable {
    protected static final long serialVersionUID = 1L;
    protected final String jobId;
    protected final String jobDefinitionId;
    protected final int retries;

    public SetJobRetriesCmd(String jobId, String jobDefinitionId, int retries) {
        if ((jobId == null || jobId.isEmpty()) && (jobDefinitionId == null || jobDefinitionId.isEmpty())) {
            throw new ProcessEngineException("Either job definition id or job id has to be provided as parameter.");
        }
        if (retries < 0) {
            throw new ProcessEngineException("The number of job retries must be a non-negative Integer, but '" + retries + "' has been provided.");
        }
        this.jobId = jobId;
        this.jobDefinitionId = jobDefinitionId;
        this.retries = retries;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.jobId != null) {
            this.setJobRetriesByJobId(this.jobId, this.retries, commandContext);
        } else {
            this.setJobRetriesByJobDefinitionId(commandContext);
        }
        return null;
    }

    protected void setJobRetriesByJobDefinitionId(CommandContext commandContext) {
        JobDefinitionManager jobDefinitionManager = commandContext.getJobDefinitionManager();
        JobDefinitionEntity jobDefinition = jobDefinitionManager.findById(this.jobDefinitionId);
        if (jobDefinition != null) {
            String processDefinitionId = jobDefinition.getProcessDefinitionId();
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateRetriesProcessInstanceByProcessDefinitionId(processDefinitionId);
            }
        }
        commandContext.getJobManager().updateFailedJobRetriesByJobDefinitionId(this.jobDefinitionId, this.retries);
        PropertyChange propertyChange = new PropertyChange("retries", null, this.retries);
        commandContext.getOperationLogManager().logJobOperation(this.getLogEntryOperation(), null, this.jobDefinitionId, null, null, null, propertyChange);
    }
}

