/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd.batch.removaltime;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.authorization.BatchPermissions;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.BatchJobHandler;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.batch.AbstractIDBasedBatchCmd;
import org.camunda.bpm.engine.impl.history.SetRemovalTimeToHistoricProcessInstancesBuilderImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetRemovalTimeToHistoricProcessInstancesCmd
extends AbstractIDBasedBatchCmd<Batch> {
    protected SetRemovalTimeToHistoricProcessInstancesBuilderImpl builder;

    public SetRemovalTimeToHistoricProcessInstancesCmd(SetRemovalTimeToHistoricProcessInstancesBuilderImpl builder) {
        this.builder = builder;
    }

    @Override
    public Batch execute(CommandContext commandContext) {
        HashSet<String> historicProcessInstanceIds = new HashSet<String>();
        List<String> instanceIds = this.builder.getIds();
        HistoricProcessInstanceQuery instanceQuery = this.builder.getQuery();
        if (instanceQuery == null && instanceIds == null) {
            throw new BadUserRequestException("Either query nor ids provided.");
        }
        if (instanceQuery != null) {
            for (HistoricProcessInstance historicDecisionInstance : instanceQuery.list()) {
                historicProcessInstanceIds.add(historicDecisionInstance.getId());
            }
        }
        if (instanceIds != null) {
            historicProcessInstanceIds.addAll(this.findHistoricInstanceIds(instanceIds, commandContext));
        }
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "removalTime", (Object)this.builder.getMode());
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "historicProcessInstances", historicProcessInstanceIds);
        this.checkAuthorizations(commandContext, BatchPermissions.CREATE_BATCH_SET_REMOVAL_TIME);
        this.writeUserOperationLog(commandContext, historicProcessInstanceIds.size(), this.builder.getMode(), this.builder.getRemovalTime(), this.builder.isHierarchical(), true);
        BatchEntity batch = this.createBatch(commandContext, new ArrayList<String>(historicProcessInstanceIds));
        batch.createSeedJobDefinition();
        batch.createMonitorJobDefinition();
        batch.createBatchJobDefinition();
        batch.fireHistoricStartEvent();
        batch.createSeedJob();
        return batch;
    }

    protected List<String> findHistoricInstanceIds(List<String> instanceIds, CommandContext commandContext) {
        List historicProcessInstances = this.createHistoricDecisionInstanceQuery(commandContext).processInstanceIds(new HashSet<String>(instanceIds)).list();
        ArrayList<String> ids = new ArrayList<String>();
        for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
            ids.add(historicProcessInstance.getId());
        }
        return ids;
    }

    protected HistoricProcessInstanceQuery createHistoricDecisionInstanceQuery(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryService().createHistoricProcessInstanceQuery();
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances, SetRemovalTimeToHistoricProcessInstancesBuilderImpl.Mode mode, Date removalTime, boolean hierarchical, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("mode", null, (Object)mode));
        propertyChanges.add(new PropertyChange("removalTime", null, removalTime));
        propertyChanges.add(new PropertyChange("hierarchical", null, hierarchical));
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        commandContext.getOperationLogManager().logProcessInstanceOperation("SetRemovalTime", propertyChanges);
    }

    @Override
    protected BatchConfiguration getAbstractIdsBatchConfiguration(List<String> ids) {
        return new SetRemovalTimeBatchConfiguration(ids).setHierarchical(this.builder.isHierarchical()).setHasRemovalTime(this.hasRemovalTime(this.builder.getMode())).setRemovalTime(this.builder.getRemovalTime());
    }

    protected boolean hasRemovalTime(SetRemovalTimeToHistoricProcessInstancesBuilderImpl.Mode mode) {
        return this.builder.getMode() == SetRemovalTimeToHistoricProcessInstancesBuilderImpl.Mode.ABSOLUTE_REMOVAL_TIME || this.builder.getMode() == SetRemovalTimeToHistoricProcessInstancesBuilderImpl.Mode.CLEARED_REMOVAL_TIME;
    }

    @Override
    protected BatchJobHandler getBatchJobHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return processEngineConfiguration.getBatchHandlers().get("process-set-removal-time");
    }
}

