/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.db.sql;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.QueryOrderingProperty;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.sql.CaseDefinitionTableMapping;
import org.camunda.bpm.engine.impl.db.sql.MyBatisTableMapping;
import org.camunda.bpm.engine.impl.db.sql.ProcessDefinitionTableMapping;
import org.camunda.bpm.engine.impl.db.sql.VariableTableMapping;
import org.camunda.bpm.engine.query.QueryProperty;

public class MybatisJoinHelper {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected static final String DEFAULT_ORDER = "RES.ID_ asc";
    public static Map<String, MyBatisTableMapping> mappings = new HashMap<String, MyBatisTableMapping>();

    public static String tableAlias(String relation, int index) {
        if (relation == null) {
            return "RES";
        }
        MyBatisTableMapping mapping = MybatisJoinHelper.getTableMapping(relation);
        if (mapping.isOneToOneRelation()) {
            return mapping.getTableAlias();
        }
        return mapping.getTableAlias() + index;
    }

    public static String tableMapping(String relation) {
        MyBatisTableMapping mapping = MybatisJoinHelper.getTableMapping(relation);
        return mapping.getTableName();
    }

    public static String orderBySelection(QueryOrderingProperty orderingProperty, int index) {
        QueryProperty queryProperty = orderingProperty.getQueryProperty();
        StringBuilder sb = new StringBuilder();
        if (queryProperty.getFunction() != null) {
            sb.append(queryProperty.getFunction());
            sb.append("(");
        }
        sb.append(MybatisJoinHelper.tableAlias(orderingProperty.getRelation(), index));
        sb.append(".");
        sb.append(queryProperty.getName());
        if (queryProperty.getFunction() != null) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static String orderBy(QueryOrderingProperty orderingProperty, int index) {
        QueryProperty queryProperty = orderingProperty.getQueryProperty();
        StringBuilder sb = new StringBuilder();
        sb.append(MybatisJoinHelper.tableAlias(orderingProperty.getRelation(), index));
        if (orderingProperty.isContainedProperty()) {
            sb.append(".");
        } else {
            sb.append("_");
        }
        sb.append(queryProperty.getName());
        sb.append(" ");
        sb.append(orderingProperty.getDirection().getName());
        return sb.toString();
    }

    protected static MyBatisTableMapping getTableMapping(String relation) {
        MyBatisTableMapping mapping = mappings.get(relation);
        if (mapping == null) {
            throw LOG.missingRelationMappingException(relation);
        }
        return mapping;
    }

    static {
        mappings.put("variable", new VariableTableMapping());
        mappings.put("process-definition", new ProcessDefinitionTableMapping());
        mappings.put("case-definition", new CaseDefinitionTableMapping());
    }
}

