/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.commons.logging.MdcAccess;

public class ProcessDataLoggingContext {
    private static final String NULL_VALUE = "~NULL_VALUE~";
    private String propertyActivityId;
    private String propertyApplicationName;
    private String propertyBusinessKey;
    private String propertyDefinitionId;
    private String propertyInstanceId;
    private String propertyTenantId;
    private List<String> propertyNames = new ArrayList<String>();
    private Map<String, Deque<String>> propertyValues = new HashMap<String, Deque<String>>();
    private boolean startNewSection = false;
    private Deque<List<String>> sections = new ArrayDeque<List<String>>();

    public ProcessDataLoggingContext(ProcessEngineConfigurationImpl configuration) {
        this.propertyActivityId = configuration.getLoggingContextActivityId();
        if (ProcessDataLoggingContext.isNotBlank(this.propertyActivityId)) {
            this.propertyNames.add(this.propertyActivityId);
        }
        this.propertyApplicationName = configuration.getLoggingContextApplicationName();
        if (ProcessDataLoggingContext.isNotBlank(this.propertyApplicationName)) {
            this.propertyNames.add(this.propertyApplicationName);
        }
        this.propertyBusinessKey = configuration.getLoggingContextBusinessKey();
        if (ProcessDataLoggingContext.isNotBlank(this.propertyBusinessKey)) {
            this.propertyNames.add(this.propertyBusinessKey);
        }
        this.propertyDefinitionId = configuration.getLoggingContextProcessDefinitionId();
        if (ProcessDataLoggingContext.isNotBlank(this.propertyDefinitionId)) {
            this.propertyNames.add(this.propertyDefinitionId);
        }
        this.propertyInstanceId = configuration.getLoggingContextProcessInstanceId();
        if (ProcessDataLoggingContext.isNotBlank(this.propertyInstanceId)) {
            this.propertyNames.add(this.propertyInstanceId);
        }
        this.propertyTenantId = configuration.getLoggingContextTenantId();
        if (ProcessDataLoggingContext.isNotBlank(this.propertyTenantId)) {
            this.propertyNames.add(this.propertyTenantId);
        }
    }

    public boolean pushSection(ExecutionEntity execution) {
        if (!this.propertyNames.isEmpty()) {
            ProcessApplicationReference currentPa;
            if (this.propertyValues.isEmpty()) {
                this.clearMdc();
            }
            this.startNewSection = true;
            this.addToStackAndMdc(execution.getActivityId(), this.propertyActivityId);
            this.addToStackAndMdc(execution.getProcessDefinitionId(), this.propertyDefinitionId);
            this.addToStackAndMdc(execution.getProcessInstanceId(), this.propertyInstanceId);
            this.addToStackAndMdc(execution.getTenantId(), this.propertyTenantId);
            if (ProcessDataLoggingContext.isNotBlank(this.propertyApplicationName) && (currentPa = Context.getCurrentProcessApplication()) != null) {
                this.addToStackAndMdc(currentPa.getName(), this.propertyApplicationName);
            }
            if (ProcessDataLoggingContext.isNotBlank(this.propertyBusinessKey)) {
                this.addToStackAndMdc(execution.getBusinessKey(), this.propertyBusinessKey);
            }
            if (!this.startNewSection) {
                return true;
            }
            this.startNewSection = false;
        }
        return false;
    }

    public void popSection() {
        List<String> section;
        if (!this.propertyNames.isEmpty() && (section = this.sections.pollFirst()) != null) {
            for (String property : section) {
                this.removeFromStackAndUpdateMdc(property);
            }
        }
    }

    public void clearMdc() {
        for (String property : this.propertyNames) {
            MdcAccess.remove((String)property);
        }
    }

    public void update() {
        if (!this.propertyValues.isEmpty()) {
            for (String property : this.propertyNames) {
                this.updateMdc(property);
            }
        }
    }

    public void fetchCurrentContext() {
        if (!this.propertyNames.isEmpty()) {
            this.startNewSection = true;
            for (String property : this.propertyNames) {
                this.addToStack(MdcAccess.get((String)property), property, false);
            }
            this.startNewSection = false;
        }
    }

    protected void addToStackAndMdc(String value, String property) {
        this.addToStack(value, property, true);
    }

    protected void addToStack(String value, String property, boolean addToMdc) {
        if (!ProcessDataLoggingContext.isNotBlank(property)) {
            return;
        }
        Deque<String> deque = this.getDeque(property);
        String current = deque.peekFirst();
        if (ProcessDataLoggingContext.valuesEqual(current, value)) {
            return;
        }
        this.addToCurrentSection(property);
        if (value == null) {
            deque.addFirst(NULL_VALUE);
            if (addToMdc) {
                MdcAccess.remove((String)property);
            }
        } else {
            deque.addFirst(value);
            if (addToMdc) {
                MdcAccess.put((String)property, (String)value);
            }
        }
    }

    protected void removeFromStackAndUpdateMdc(String property) {
        if (property == null) {
            return;
        }
        this.getDeque(property).removeFirst();
        this.updateMdc(property);
    }

    protected Deque<String> getDeque(String property) {
        Deque<String> deque = this.propertyValues.get(property);
        if (deque == null) {
            deque = new ArrayDeque<String>();
            this.propertyValues.put(property, deque);
        }
        return deque;
    }

    protected void addToCurrentSection(String property) {
        List<String> section = this.sections.peekFirst();
        if (this.startNewSection) {
            section = new ArrayList<String>();
            this.sections.addFirst(section);
            this.startNewSection = false;
        }
        section.add(property);
    }

    protected void updateMdc(String property) {
        String previousValue;
        String string = previousValue = this.propertyValues.containsKey(property) ? this.propertyValues.get(property).peekFirst() : null;
        if (ProcessDataLoggingContext.isNull(previousValue)) {
            MdcAccess.remove((String)property);
        } else {
            MdcAccess.put((String)property, (String)previousValue);
        }
    }

    protected static boolean isNotBlank(String property) {
        return property != null && !property.trim().isEmpty();
    }

    protected static boolean valuesEqual(String val1, String val2) {
        if (ProcessDataLoggingContext.isNull(val1)) {
            return val2 == null;
        }
        return val1.equals(val2);
    }

    protected static boolean isNull(String value) {
        return value == null || NULL_VALUE.equals(value);
    }
}

