/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.removaltime;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobDeclaration;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.removaltime.SetRemovalTimeJsonConverter;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.repository.DecisionDefinition;

public class DecisionSetRemovalTimeJobHandler
extends AbstractBatchJobHandler<SetRemovalTimeBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("decision-set-removal-time");

    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        if (this.isDmnEnabled(commandContext)) {
            String byteArrayId = configuration.getConfigurationByteArrayId();
            byte[] configurationByteArray = this.findByteArrayById(byteArrayId, commandContext).getBytes();
            SetRemovalTimeBatchConfiguration batchConfiguration = (SetRemovalTimeBatchConfiguration)this.readConfiguration(configurationByteArray);
            for (String instanceId : batchConfiguration.getIds()) {
                HistoricDecisionInstanceEntity instance = this.findDecisionInstanceById(instanceId, commandContext);
                if (instance == null) continue;
                if (batchConfiguration.isHierarchical()) {
                    String rootDecisionInstanceId = this.getRootDecisionInstance(instance);
                    HistoricDecisionInstanceEntity rootInstance = this.findDecisionInstanceById(rootDecisionInstanceId, commandContext);
                    Date removalTime = this.getOrCalculateRemovalTime(batchConfiguration, rootInstance, commandContext);
                    this.addRemovalTimeToHierarchy(rootDecisionInstanceId, removalTime, commandContext);
                    continue;
                }
                Date removalTime = this.getOrCalculateRemovalTime(batchConfiguration, instance, commandContext);
                if (removalTime == instance.getRemovalTime()) continue;
                this.addRemovalTime(instanceId, removalTime, commandContext);
            }
        }
    }

    protected String getRootDecisionInstance(HistoricDecisionInstanceEntity instance) {
        return instance.getRootDecisionInstanceId() == null ? instance.getId() : instance.getRootDecisionInstanceId();
    }

    protected Date getOrCalculateRemovalTime(SetRemovalTimeBatchConfiguration batchConfiguration, HistoricDecisionInstanceEntity instance, CommandContext commandContext) {
        if (batchConfiguration.hasRemovalTime()) {
            return batchConfiguration.getRemovalTime();
        }
        if (this.hasBaseTime(commandContext)) {
            return this.calculateRemovalTime(instance, commandContext);
        }
        return null;
    }

    protected void addRemovalTimeToHierarchy(String instanceId, Date removalTime, CommandContext commandContext) {
        commandContext.getHistoricDecisionInstanceManager().addRemovalTimeToDecisionsByRootDecisionInstanceId(instanceId, removalTime);
    }

    protected void addRemovalTime(String instanceId, Date removalTime, CommandContext commandContext) {
        commandContext.getHistoricDecisionInstanceManager().addRemovalTimeToDecisionsByDecisionInstanceId(instanceId, removalTime);
    }

    protected boolean hasBaseTime(CommandContext commandContext) {
        return this.isStrategyStart(commandContext) || this.isStrategyEnd(commandContext);
    }

    protected boolean isStrategyStart(CommandContext commandContext) {
        return "start".equals(this.getHistoryRemovalTimeStrategy(commandContext));
    }

    protected boolean isStrategyEnd(CommandContext commandContext) {
        return "end".equals(this.getHistoryRemovalTimeStrategy(commandContext));
    }

    protected String getHistoryRemovalTimeStrategy(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected DecisionDefinition findDecisionDefinitionById(String decisionDefinitionId, CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedDecisionDefinitionById(decisionDefinitionId);
    }

    protected boolean isDmnEnabled(CommandContext commandContext) {
        return commandContext.getProcessEngineConfiguration().isDmnEnabled();
    }

    protected Date calculateRemovalTime(HistoricDecisionInstanceEntity decisionInstance, CommandContext commandContext) {
        DecisionDefinition decisionDefinition = this.findDecisionDefinitionById(decisionInstance.getDecisionDefinitionId(), commandContext);
        return commandContext.getProcessEngineConfiguration().getHistoryRemovalTimeProvider().calculateRemovalTime(decisionInstance, decisionDefinition);
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId, CommandContext commandContext) {
        return commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, byteArrayId);
    }

    protected HistoricDecisionInstanceEntity findDecisionInstanceById(String instanceId, CommandContext commandContext) {
        return commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstance(instanceId);
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected SetRemovalTimeBatchConfiguration createJobConfiguration(SetRemovalTimeBatchConfiguration configuration, List<String> decisionInstanceIds) {
        return new SetRemovalTimeBatchConfiguration(decisionInstanceIds).setRemovalTime(configuration.getRemovalTime()).setHasRemovalTime(configuration.hasRemovalTime()).setHierarchical(configuration.isHierarchical());
    }

    @Override
    protected JsonObjectConverter getJsonConverterInstance() {
        return SetRemovalTimeJsonConverter.INSTANCE;
    }

    @Override
    public String getType() {
        return "decision-set-removal-time";
    }
}

