/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch.update;

import java.util.List;
import org.camunda.bpm.engine.impl.UpdateProcessInstancesSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.camunda.bpm.engine.impl.batch.BatchJobConfiguration;
import org.camunda.bpm.engine.impl.batch.BatchJobContext;
import org.camunda.bpm.engine.impl.batch.BatchJobDeclaration;
import org.camunda.bpm.engine.impl.batch.update.UpdateProcessInstancesSuspendStateBatchConfiguration;
import org.camunda.bpm.engine.impl.batch.update.UpdateProcessInstancesSuspendStateBatchConfigurationJsonConverter;
import org.camunda.bpm.engine.impl.cmd.UpdateProcessInstancesSuspendStateCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;

public class UpdateProcessInstancesSuspendStateJobHandler
extends AbstractBatchJobHandler<UpdateProcessInstancesSuspendStateBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("instance-update-suspension-state");

    @Override
    public String getType() {
        return "instance-update-suspension-state";
    }

    protected UpdateProcessInstancesSuspendStateBatchConfigurationJsonConverter getJsonConverterInstance() {
        return UpdateProcessInstancesSuspendStateBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected UpdateProcessInstancesSuspendStateBatchConfiguration createJobConfiguration(UpdateProcessInstancesSuspendStateBatchConfiguration configuration, List<String> processIdsForJob) {
        return new UpdateProcessInstancesSuspendStateBatchConfiguration(processIdsForJob, configuration.getSuspended());
    }

    @Override
    public void execute(BatchJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        ByteArrayEntity configurationEntity = commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, configuration.getConfigurationByteArrayId());
        UpdateProcessInstancesSuspendStateBatchConfiguration batchConfiguration = (UpdateProcessInstancesSuspendStateBatchConfiguration)this.readConfiguration(configurationEntity.getBytes());
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandContext.executeWithOperationLogPrevented(new UpdateProcessInstancesSuspendStateCmd(commandExecutor, new UpdateProcessInstancesSuspensionStateBuilderImpl(batchConfiguration.getIds()), batchConfiguration.getSuspended()));
    }
}

