/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor.historycleanup;

import java.util.Map;
import org.camunda.bpm.engine.impl.cfg.TransactionListener;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupJobHandlerConfiguration;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.HistoryCleanupSchedulerCmd;

public abstract class HistoryCleanupHandler
implements TransactionListener {
    public static final int MAX_BATCH_SIZE = 500;
    protected HistoryCleanupJobHandlerConfiguration configuration;
    protected String jobId;
    protected CommandExecutor commandExecutor;

    @Override
    public void execute(CommandContext commandContext) {
        this.commandExecutor.execute(new HistoryCleanupHandlerCmd());
    }

    abstract void performCleanup();

    abstract Map<String, Long> reportMetrics();

    abstract boolean shouldRescheduleNow();

    public HistoryCleanupJobHandlerConfiguration getConfiguration() {
        return this.configuration;
    }

    public HistoryCleanupHandler setConfiguration(HistoryCleanupJobHandlerConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HistoryCleanupHandler setJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public HistoryCleanupHandler setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    protected class HistoryCleanupHandlerCmd
    implements Command<Void> {
        protected HistoryCleanupHandlerCmd() {
        }

        @Override
        public Void execute(CommandContext commandContext) {
            Map<String, Long> report = HistoryCleanupHandler.this.reportMetrics();
            boolean isRescheduleNow = HistoryCleanupHandler.this.shouldRescheduleNow();
            new HistoryCleanupSchedulerCmd(isRescheduleNow, report, HistoryCleanupHandler.this.configuration, HistoryCleanupHandler.this.jobId).execute(commandContext);
            return null;
        }
    }
}

