/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.ActivityExecutionTreeMapping;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingEventScopeInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingExternalTaskInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessElementInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingProcessInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParser;
import org.camunda.bpm.engine.impl.migration.validation.instance.MigratingProcessInstanceValidationReportImpl;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.runtime.TransitionInstance;

public class MigratingInstanceParseContext {
    protected MigratingProcessInstance migratingProcessInstance;
    protected Map<String, MigratingActivityInstance> activityInstances = new HashMap<String, MigratingActivityInstance>();
    protected Map<String, MigratingEventScopeInstance> compensationInstances = new HashMap<String, MigratingEventScopeInstance>();
    protected Map<String, MigratingJobInstance> migratingJobs = new HashMap<String, MigratingJobInstance>();
    protected Map<String, MigratingExternalTaskInstance> migratingExternalTasks = new HashMap<String, MigratingExternalTaskInstance>();
    protected Collection<EventSubscriptionEntity> eventSubscriptions;
    protected Collection<IncidentEntity> incidents;
    protected Collection<JobEntity> jobs;
    protected Collection<TaskEntity> tasks;
    protected Collection<ExternalTaskEntity> externalTasks;
    protected Collection<VariableInstanceEntity> variables;
    protected ProcessDefinitionEntity sourceProcessDefinition;
    protected ProcessDefinitionEntity targetProcessDefinition;
    protected Map<String, List<JobDefinitionEntity>> targetJobDefinitions;
    protected ActivityExecutionTreeMapping mapping;
    protected Map<String, List<MigrationInstruction>> instructionsBySourceScope;
    protected MigratingInstanceParser parser;

    public MigratingInstanceParseContext(MigratingInstanceParser parser, MigrationPlan migrationPlan, ExecutionEntity processInstance, ProcessDefinitionEntity targetProcessDefinition) {
        this.parser = parser;
        this.sourceProcessDefinition = processInstance.getProcessDefinition();
        this.targetProcessDefinition = targetProcessDefinition;
        this.migratingProcessInstance = new MigratingProcessInstance(processInstance.getId(), this.sourceProcessDefinition, targetProcessDefinition);
        this.mapping = new ActivityExecutionTreeMapping(Context.getCommandContext(), processInstance.getId());
        this.instructionsBySourceScope = this.organizeInstructionsBySourceScope(migrationPlan);
    }

    public MigratingInstanceParseContext jobs(Collection<JobEntity> jobs) {
        this.jobs = new HashSet<JobEntity>(jobs);
        return this;
    }

    public MigratingInstanceParseContext incidents(Collection<IncidentEntity> incidents) {
        this.incidents = new HashSet<IncidentEntity>(incidents);
        return this;
    }

    public MigratingInstanceParseContext tasks(Collection<TaskEntity> tasks) {
        this.tasks = new HashSet<TaskEntity>(tasks);
        return this;
    }

    public MigratingInstanceParseContext externalTasks(Collection<ExternalTaskEntity> externalTasks) {
        this.externalTasks = new HashSet<ExternalTaskEntity>(externalTasks);
        return this;
    }

    public MigratingInstanceParseContext eventSubscriptions(Collection<EventSubscriptionEntity> eventSubscriptions) {
        this.eventSubscriptions = new HashSet<EventSubscriptionEntity>(eventSubscriptions);
        return this;
    }

    public MigratingInstanceParseContext targetJobDefinitions(Collection<JobDefinitionEntity> jobDefinitions) {
        this.targetJobDefinitions = new HashMap<String, List<JobDefinitionEntity>>();
        for (JobDefinitionEntity jobDefinition : jobDefinitions) {
            CollectionUtil.addToMapOfLists(this.targetJobDefinitions, jobDefinition.getActivityId(), jobDefinition);
        }
        return this;
    }

    public MigratingInstanceParseContext variables(Collection<VariableInstanceEntity> variables) {
        this.variables = new HashSet<VariableInstanceEntity>(variables);
        return this;
    }

    public void submit(MigratingActivityInstance activityInstance) {
        this.activityInstances.put(activityInstance.getActivityInstance().getId(), activityInstance);
    }

    public void submit(MigratingEventScopeInstance compensationInstance) {
        ExecutionEntity scopeExecution = compensationInstance.resolveRepresentativeExecution();
        if (scopeExecution != null) {
            this.compensationInstances.put(scopeExecution.getId(), compensationInstance);
        }
    }

    public void submit(MigratingJobInstance job) {
        this.migratingJobs.put(job.getJobEntity().getId(), job);
    }

    public void submit(MigratingExternalTaskInstance externalTask) {
        this.migratingExternalTasks.put(externalTask.getId(), externalTask);
    }

    public void consume(TaskEntity task) {
        this.tasks.remove(task);
    }

    public void consume(ExternalTaskEntity externalTask) {
        this.externalTasks.remove(externalTask);
    }

    public void consume(IncidentEntity incident) {
        this.incidents.remove(incident);
    }

    public void consume(JobEntity job) {
        this.jobs.remove(job);
    }

    public void consume(EventSubscriptionEntity eventSubscription) {
        this.eventSubscriptions.remove(eventSubscription);
    }

    public void consume(VariableInstanceEntity variableInstance) {
        this.variables.remove(variableInstance);
    }

    public MigratingProcessInstance getMigratingProcessInstance() {
        return this.migratingProcessInstance;
    }

    public Collection<MigratingActivityInstance> getMigratingActivityInstances() {
        return this.activityInstances.values();
    }

    public ProcessDefinitionImpl getSourceProcessDefinition() {
        return this.sourceProcessDefinition;
    }

    public ProcessDefinitionImpl getTargetProcessDefinition() {
        return this.targetProcessDefinition;
    }

    public ActivityImpl getTargetActivity(MigrationInstruction instruction) {
        if (instruction != null) {
            return this.targetProcessDefinition.findActivity(instruction.getTargetActivityId());
        }
        return null;
    }

    public JobDefinitionEntity getTargetJobDefinition(String activityId, String jobHandlerType) {
        List<JobDefinitionEntity> jobDefinitionsForActivity = this.targetJobDefinitions.get(activityId);
        if (jobDefinitionsForActivity != null) {
            for (JobDefinitionEntity jobDefinition : jobDefinitionsForActivity) {
                if (!jobHandlerType.equals(jobDefinition.getJobType())) continue;
                return jobDefinition;
            }
        }
        return null;
    }

    public ActivityExecutionTreeMapping getMapping() {
        return this.mapping;
    }

    public MigrationInstruction getInstructionFor(String scopeId) {
        List<MigrationInstruction> instructions = this.instructionsBySourceScope.get(scopeId);
        if (instructions == null || instructions.isEmpty()) {
            return null;
        }
        return instructions.get(0);
    }

    public MigratingActivityInstance getMigratingActivityInstanceById(String activityInstanceId) {
        return this.activityInstances.get(activityInstanceId);
    }

    public MigratingScopeInstance getMigratingCompensationInstanceByExecutionId(String id) {
        return this.compensationInstances.get(id);
    }

    public MigratingJobInstance getMigratingJobInstanceById(String jobId) {
        return this.migratingJobs.get(jobId);
    }

    public MigratingExternalTaskInstance getMigratingExternalTaskInstanceById(String externalTaskId) {
        return this.migratingExternalTasks.get(externalTaskId);
    }

    public MigrationInstruction findSingleMigrationInstruction(String sourceScopeId) {
        List<MigrationInstruction> instructions = this.instructionsBySourceScope.get(sourceScopeId);
        if (instructions != null && !instructions.isEmpty()) {
            return instructions.get(0);
        }
        return null;
    }

    protected Map<String, List<MigrationInstruction>> organizeInstructionsBySourceScope(MigrationPlan migrationPlan) {
        HashMap<String, List<MigrationInstruction>> organizedInstructions = new HashMap<String, List<MigrationInstruction>>();
        for (MigrationInstruction instruction : migrationPlan.getInstructions()) {
            CollectionUtil.addToMapOfLists(organizedInstructions, instruction.getSourceActivityId(), instruction);
        }
        return organizedInstructions;
    }

    public void handleDependentActivityInstanceJobs(MigratingActivityInstance migratingInstance, List<JobEntity> jobs) {
        this.parser.getDependentActivityInstanceJobHandler().handle(this, migratingInstance, jobs);
    }

    public void handleDependentTransitionInstanceJobs(MigratingTransitionInstance migratingInstance, List<JobEntity> jobs) {
        this.parser.getDependentTransitionInstanceJobHandler().handle(this, migratingInstance, jobs);
    }

    public void handleDependentEventSubscriptions(MigratingActivityInstance migratingInstance, List<EventSubscriptionEntity> eventSubscriptions) {
        this.parser.getDependentEventSubscriptionHandler().handle(this, migratingInstance, eventSubscriptions);
    }

    public void handleDependentVariables(MigratingProcessElementInstance migratingInstance, List<VariableInstanceEntity> variables) {
        this.parser.getDependentVariablesHandler().handle(this, migratingInstance, variables);
    }

    public void handleTransitionInstance(TransitionInstance transitionInstance) {
        this.parser.getTransitionInstanceHandler().handle(this, transitionInstance);
    }

    public void validateNoEntitiesLeft(MigratingProcessInstanceValidationReportImpl processInstanceReport) {
        processInstanceReport.setProcessInstanceId(this.migratingProcessInstance.getProcessInstanceId());
        this.ensureNoEntitiesAreLeft("tasks", this.tasks, processInstanceReport);
        this.ensureNoEntitiesAreLeft("externalTask", this.externalTasks, processInstanceReport);
        this.ensureNoEntitiesAreLeft("incidents", this.incidents, processInstanceReport);
        this.ensureNoEntitiesAreLeft("jobs", this.jobs, processInstanceReport);
        this.ensureNoEntitiesAreLeft("event subscriptions", this.eventSubscriptions, processInstanceReport);
        this.ensureNoEntitiesAreLeft("variables", this.variables, processInstanceReport);
    }

    public void ensureNoEntitiesAreLeft(String entityName, Collection<? extends DbEntity> dbEntities, MigratingProcessInstanceValidationReportImpl processInstanceReport) {
        if (!dbEntities.isEmpty()) {
            processInstanceReport.addFailure("Process instance contains not migrated " + entityName + ": [" + StringUtil.joinDbEntityIds(dbEntities) + "]");
        }
    }
}

