/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;

public class CorrelateStartMessageCmd
extends AbstractCorrelateMessageCmd
implements Command<ProcessInstance> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;

    public CorrelateStartMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl) {
        super(messageCorrelationBuilderImpl);
    }

    @Override
    public ProcessInstance execute(final CommandContext commandContext) {
        EnsureUtil.ensureNotNull("messageName", (Object)this.messageName);
        final CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        final CorrelationSet correlationSet = new CorrelationSet(this.builder);
        List<MessageCorrelationResult> correlationResults = commandContext.runWithoutAuthorization(new Callable<List<MessageCorrelationResult>>(){

            @Override
            public List<MessageCorrelationResult> call() throws Exception {
                return correlationHandler.correlateStartMessages(commandContext, CorrelateStartMessageCmd.this.messageName, correlationSet);
            }
        });
        if (correlationResults.isEmpty()) {
            throw new MismatchingMessageCorrelationException(this.messageName, "No process definition matches the parameters");
        }
        if (correlationResults.size() > 1) {
            throw LOG.exceptionCorrelateMessageToSingleProcessDefinition(this.messageName, correlationResults.size(), correlationSet);
        }
        MessageCorrelationResult correlationResult = correlationResults.get(0);
        this.checkAuthorization(correlationResult);
        ProcessInstance processInstance = this.instantiateProcess(commandContext, correlationResult);
        return processInstance;
    }
}

