/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;

public class ModifyProcessInstanceCmd
implements Command<Void> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessInstanceModificationBuilderImpl builder;

    public ModifyProcessInstanceCmd(ProcessInstanceModificationBuilderImpl processInstanceModificationBuilder) {
        this.builder = processInstanceModificationBuilder;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        String processInstanceId = this.builder.getProcessInstanceId();
        ExecutionManager executionManager = commandContext.getExecutionManager();
        ExecutionEntity processInstance = executionManager.findExecutionById(processInstanceId);
        this.checkUpdateProcessInstance(processInstance, commandContext);
        processInstance.setPreserveScope(true);
        List<AbstractProcessInstanceModificationCommand> instructions = this.builder.getModificationOperations();
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractProcessInstanceModificationCommand instruction = instructions.get(i);
            LOG.debugModificationInstruction(processInstanceId, i + 1, instruction.describe());
            instruction.setSkipCustomListeners(this.builder.isSkipCustomListeners());
            instruction.setSkipIoMappings(this.builder.isSkipIoMappings());
            instruction.execute(commandContext);
        }
        processInstance = executionManager.findExecutionById(processInstanceId);
        if (!processInstance.hasChildren()) {
            if (processInstance.getActivity() == null) {
                this.checkDeleteProcessInstance(processInstance, commandContext);
                processInstance.deleteCascade("Cancellation due to process instance modification", this.builder.isSkipCustomListeners(), this.builder.isSkipIoMappings());
            } else if (processInstance.isEnded()) {
                processInstance.propagateEnd();
            }
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation(this.getLogEntryOperation(), processInstanceId, null, null, Collections.singletonList(PropertyChange.EMPTY_CHANGE));
        return null;
    }

    protected String getLogEntryOperation() {
        return "ModifyProcessInstance";
    }

    protected void checkUpdateProcessInstance(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstance(execution);
        }
    }

    protected void checkDeleteProcessInstance(ExecutionEntity execution, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteProcessInstance(execution);
        }
    }
}

