/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.migration.instance.parser;

import org.camunda.bpm.engine.impl.migration.instance.MigratingExternalTaskInstance;
import org.camunda.bpm.engine.impl.migration.instance.MigratingIncident;
import org.camunda.bpm.engine.impl.migration.instance.MigratingJobInstance;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseContext;
import org.camunda.bpm.engine.impl.migration.instance.parser.MigratingInstanceParseHandler;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;

public class IncidentInstanceHandler
implements MigratingInstanceParseHandler<IncidentEntity> {
    @Override
    public void handle(MigratingInstanceParseContext parseContext, IncidentEntity incident) {
        if (this.isFailedJobIncident(incident)) {
            this.handleFailedJobIncident(parseContext, incident);
        } else if (this.isExternalTaskIncident(incident)) {
            this.handleExternalTaskIncident(parseContext, incident);
        }
    }

    protected boolean isFailedJobIncident(IncidentEntity incident) {
        return "failedJob".equals(incident.getIncidentType());
    }

    protected void handleFailedJobIncident(MigratingInstanceParseContext parseContext, IncidentEntity incident) {
        MigratingJobInstance owningInstance = parseContext.getMigratingJobInstanceById(incident.getConfiguration());
        parseContext.consume(incident);
        if (owningInstance != null && owningInstance.migrates()) {
            MigratingIncident migratingIncident = new MigratingIncident(incident, owningInstance.getTargetScope());
            JobDefinitionEntity targetJobDefinitionEntity = owningInstance.getTargetJobDefinitionEntity();
            if (targetJobDefinitionEntity != null) {
                migratingIncident.setTargetJobDefinitionId(targetJobDefinitionEntity.getId());
            }
            owningInstance.addMigratingDependentInstance(migratingIncident);
        }
    }

    protected boolean isExternalTaskIncident(IncidentEntity incident) {
        return "failedExternalTask".equals(incident.getIncidentType());
    }

    protected void handleExternalTaskIncident(MigratingInstanceParseContext parseContext, IncidentEntity incident) {
        MigratingExternalTaskInstance owningInstance = parseContext.getMigratingExternalTaskInstanceById(incident.getConfiguration());
        parseContext.consume(incident);
        if (owningInstance != null) {
            MigratingIncident migratingIncident = new MigratingIncident(incident, owningInstance.getTargetScope());
            owningInstance.addMigratingDependentInstance(migratingIncident);
        }
    }
}

