/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.json.JSONArray;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public final class JsonUtil {
    public static Map<String, Object> jsonObjectAsMap(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (jsonObject.optJSONObject(key) != null) {
                map.put(key, JsonUtil.jsonObjectAsMap(jsonObject.getJSONObject(key)));
                continue;
            }
            if (jsonObject.optJSONArray(key) != null) {
                map.put(key, JsonUtil.jsonArrayAsList(jsonObject.getJSONArray(key)));
                continue;
            }
            map.put(key, jsonObject.get(key));
        }
        return map;
    }

    public static List<Object> jsonArrayAsList(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            if (jsonArray.optJSONObject(i) != null) {
                list.add(JsonUtil.jsonObjectAsMap(jsonArray.getJSONObject(i)));
                continue;
            }
            if (jsonArray.optJSONArray(i) != null) {
                list.add(JsonUtil.jsonArrayAsList(jsonArray.getJSONArray(i)));
                continue;
            }
            list.add(jsonArray.get(i));
        }
        return list;
    }

    public static void addField(JSONObject json, String name, Object value) {
        if (value != null) {
            json.put(name, value);
        }
    }

    public static <T> void addField(JSONObject json, String name, JsonObjectConverter<T> converter, T value) {
        if (value != null) {
            json.put(name, converter.toJsonObject(value));
        }
    }

    public static void addDefaultField(JSONObject json, String name, Object defaultValue, Object value) {
        if (value != null && !value.equals(defaultValue)) {
            json.put(name, value);
        }
    }

    public static void addListField(JSONObject json, String name, Collection list) {
        if (list != null) {
            json.put(name, new JSONArray(list));
        }
    }

    public static <T> void addListField(JSONObject json, String name, JsonObjectConverter<T> converter, List<T> list) {
        if (list != null) {
            ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
            for (T item : list) {
                jsonList.add(converter.toJsonObject(item));
            }
            JsonUtil.addListField(json, name, jsonList);
        }
    }

    public static void addArrayField(JSONObject json, String name, Object[] array) {
        if (array != null) {
            JsonUtil.addListField(json, name, Arrays.asList(array));
        }
    }

    public static void addDateField(JSONObject json, String name, Date date) {
        if (date != null) {
            json.put(name, date.getTime());
        }
    }

    public static <T> List<T> jsonArrayAsList(JSONArray jsonArray, JsonObjectConverter<T> converter) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(converter.toObject(jsonArray.getJSONObject(i)));
        }
        return list;
    }

    public static <T> T jsonObject(JSONObject jsonObject, JsonObjectConverter<T> converter) {
        return converter.toObject(jsonObject);
    }
}

