/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.process_test_coverage.listeners;

import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.extension.process_test_coverage.junit.rules.CoverageTestRunState;
import org.camunda.bpm.extension.process_test_coverage.model.CoveredFlowNode;

public class IntermediateEventExecutionListener
implements ExecutionListener {
    private CoverageTestRunState coverageTestRunState;

    public IntermediateEventExecutionListener(CoverageTestRunState coverageTestRunState) {
        this.coverageTestRunState = coverageTestRunState;
    }

    public void notify(DelegateExecution execution) throws Exception {
        CoveredFlowNode coveredFlowNode = this.createCoveredFlowNode(execution);
        String eventName = execution.getEventName();
        if (eventName.equals("start")) {
            this.coverageTestRunState.addCoveredElement(coveredFlowNode);
        } else if (eventName.equals("end")) {
            this.coverageTestRunState.endCoveredElement(coveredFlowNode);
        }
    }

    private CoveredFlowNode createCoveredFlowNode(DelegateExecution execution) {
        RepositoryService repositoryService = execution.getProcessEngineServices().getRepositoryService();
        ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionId(execution.getProcessDefinitionId()).singleResult();
        String currentActivityId = execution.getCurrentActivityId();
        CoveredFlowNode coveredFlowNode = new CoveredFlowNode(processDefinition.getKey(), currentActivityId);
        return coveredFlowNode;
    }
}

